"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findSecurityAIPromptsRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _prompt = require("../../lib/prompt");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findSecurityAIPromptsRoute = (router, logger) => router.versioned.get({
  access: 'public',
  path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_SECURITY_AI_PROMPTS_URL_FIND,
  security: {
    authz: {
      requiredPrivileges: ['elasticAssistant']
    }
  }
}).addVersion({
  version: _elasticAssistantCommon.API_VERSIONS.public.v1,
  validate: {
    request: {
      query: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.FindSecurityAIPromptsRequestQuery)
    },
    response: {
      200: {
        body: {
          custom: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.FindSecurityAIPromptsResponse)
        }
      }
    }
  }
}, async (context, request, response) => {
  const assistantResponse = (0, _utils.buildResponse)(response);
  try {
    const {
      query
    } = request;
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    // Perform license and authenticated user checks
    const checkResponse = await (0, _helpers.performChecks)({
      context: ctx,
      request,
      response
    });
    if (!checkResponse.isSuccess) {
      return checkResponse.response;
    }
    const actions = ctx.elasticAssistant.actions;
    const actionsClient = await actions.getActionsClientWithRequest(request);
    const savedObjectsClient = ctx.elasticAssistant.savedObjectsClient;
    const prompts = await (0, _prompt.getPromptsByGroupId)({
      actionsClient,
      connectorId: query.connector_id,
      promptGroupId: query.prompt_group_id,
      promptIds: query.prompt_ids,
      savedObjectsClient
    });
    return response.ok({
      body: {
        prompts
      }
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return assistantResponse.error({
      body: error.message,
      statusCode: error.statusCode
    });
  }
});
exports.findSecurityAIPromptsRoute = findSecurityAIPromptsRoute;