"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlQueryReference = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _popover_reference = require("./popover_reference");
var _typed_kibana_context = require("../../../../context/typed_kibana_context/typed_kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/elastic_assistant/public/src/components/get_comments/content_reference/components/esql_query_reference.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EsqlQueryReference = ({
  contentReferenceNode
}) => {
  const {
    discover: {
      locator
    },
    application: {
      navigateToApp
    }
  } = (0, _typed_kibana_context.useKibana)().services;
  const onClick = (0, _react.useCallback)(async e => {
    e.preventDefault();
    if (!locator) {
      return;
    }
    const url = await locator.getLocation({
      query: {
        esql: contentReferenceNode.contentReference.query
      },
      timeRange: contentReferenceNode.contentReference.timerange
    });
    navigateToApp(url.app, {
      path: url.path,
      openInNewTab: true
    });
  }, [locator, contentReferenceNode, navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(_popover_reference.PopoverReference, {
    contentReferenceCount: contentReferenceNode.contentReferenceCount,
    "data-test-subj": "EsqlQueryReference",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, contentReferenceNode.contentReference.label));
};
exports.EsqlQueryReference = EsqlQueryReference;