"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexStatsService = void 0;
var _lodash = require("lodash");
var _utils = require("../../common/utils");
var _process_async_in_chunks = require("../utils/process_async_in_chunks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexStatsService {
  async getIndicesDocCounts(esClient, dataStreams) {
    try {
      const {
        indices
      } = await (0, _process_async_in_chunks.processAsyncInChunks)(dataStreams, indexChunk => esClient.indices.stats({
        index: indexChunk,
        metric: ['docs'],
        forbid_closed_indices: false
      }));
      const docsCountPerDataStream = (0, _lodash.chain)(indices || {}).map((indexStats, indexName) => {
        var _indexStats$total, _indexStats$total2, _indexStats$total2$do;
        return {
          indexName,
          totalDocs: (_indexStats$total = indexStats.total) !== null && _indexStats$total !== void 0 && _indexStats$total.docs ? (_indexStats$total2 = indexStats.total) === null || _indexStats$total2 === void 0 ? void 0 : (_indexStats$total2$do = _indexStats$total2.docs) === null || _indexStats$total2$do === void 0 ? void 0 : _indexStats$total2$do.count : 0
        };
      }).groupBy(object => (0, _utils.extractIndexNameFromBackingIndex)(object.indexName)).mapValues(group => (0, _lodash.sumBy)(group, 'totalDocs')).value();
      return {
        docsCountPerDataStream
      };
    } catch (e) {
      if (e.statusCode === 404) {
        return {
          docsCountPerDataStream: {}
        };
      }
      throw e;
    }
  }
}
const indexStatsService = exports.indexStatsService = new IndexStatsService();