"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFieldLimit = updateFieldLimit;
var _boom = require("@hapi/boom");
var _utils = require("../../../utils");
var _update_component_template = require("./update_component_template");
var _update_settings_last_backing_index = require("./update_settings_last_backing_index");
var _get_datastream_settings = require("../get_datastream_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function updateFieldLimit({
  esClient,
  newFieldLimit,
  dataStream
}) {
  const datasetQualityESClient = (0, _utils.createDatasetQualityESClient)(esClient);
  const {
    lastBackingIndexName,
    indexTemplate
  } = await (0, _get_datastream_settings.getDataStreamSettings)({
    esClient,
    dataStream
  });
  if (!lastBackingIndexName || !indexTemplate) {
    throw (0, _boom.badRequest)(`Data stream does not exists. Received value "${dataStream}"`);
  }
  const {
    acknowledged: isComponentTemplateUpdated,
    componentTemplateName,
    error: errorUpdatingComponentTemplate
  } = await (0, _update_component_template.updateComponentTemplate)({
    datasetQualityESClient,
    indexTemplate,
    newFieldLimit
  });
  if (errorUpdatingComponentTemplate) {
    throw (0, _boom.badRequest)(errorUpdatingComponentTemplate);
  }
  const {
    acknowledged: isLatestBackingIndexUpdated,
    error: errorUpdatingBackingIndex
  } = await (0, _update_settings_last_backing_index.updateLastBackingIndexSettings)({
    datasetQualityESClient,
    lastBackingIndex: lastBackingIndexName,
    newFieldLimit
  });
  return {
    isComponentTemplateUpdated,
    isLatestBackingIndexUpdated,
    customComponentTemplateName: componentTemplateName,
    error: errorUpdatingBackingIndex
  };
}