"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditPipelineLink = CreateEditPipelineLink;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _translations = require("../../../../../../../common/translations");
var _utils = require("../../../../../../utils");
var _hooks = require("../../../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/dataset_quality_details/quality_issue_flyout/degraded_field/possible_mitigations/manual/pipeline_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CreateEditPipelineLink({
  areIntegrationAssetsAvailable
}) {
  const {
    services: {
      share: {
        url: {
          locators
        }
      }
    }
  } = (0, _utils.useKibanaContextForPlugin)();
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: _translations.otherMitigationsCustomIngestPipeline
  });
  const {
    datasetDetails
  } = (0, _hooks.useDatasetQualityDetailsState)();
  const {
    type,
    name
  } = datasetDetails;
  const pipelineName = areIntegrationAssetsAvailable ? `${type}-${name}@custom` : `${type}@custom`;
  const ingestPipelineLocator = locators.get('INGEST_PIPELINES_APP_LOCATOR');
  const pipelineUrl = ingestPipelineLocator === null || ingestPipelineLocator === void 0 ? void 0 : ingestPipelineLocator.useUrl({
    pipelineId: pipelineName,
    page: 'pipelines_list'
  }, {}, [pipelineName]);
  const onClickHandler = (0, _react.useCallback)(() => {
    (0, _eui.copyToClipboard)(pipelineName);
  }, [pipelineName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: accordionId,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 24
      }
    }, _translations.otherMitigationsCustomIngestPipeline),
    paddingSize: "none",
    initialIsOpen: false,
    "data-test-subj": "datasetQualityManualMitigationsPipelineAccordion",
    arrowProps: {
      color: 'primary'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.possibleMitigation.otherMitigationsCustomPipelineText1",
    defaultMessage: "{lineNumber} Copy the following pipeline name",
    values: {
      lineNumber: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.datasetQuality.editPipeline.strong.Label', {
        defaultMessage: '1.'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "copy",
      "data-test-subj": "datasetQualityManualMitigationsPipelineNameCopyButton",
      onClick: onClickHandler,
      "aria-label": _translations.manualMitigationCustomPipelineCopyPipelineNameAriaText,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }),
    readOnly: true,
    "aria-label": _translations.manualMitigationCustomPipelineCopyPipelineNameAriaText,
    value: pipelineName,
    "data-test-subj": "datasetQualityManualMitigationsPipelineName",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.details.degradedField.possibleMitigation.otherMitigationsCustomPipelineText2",
    defaultMessage: "{lineNumber} Using the name you copied, {createEditPipelineLink}",
    values: {
      lineNumber: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.datasetQuality.editPipeline.strong.Label', {
        defaultMessage: '2.'
      })),
      createEditPipelineLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "datasetQualityManualMitigationsPipelineLink",
        "data-test-url": pipelineUrl,
        href: pipelineUrl,
        target: "_blank",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 15
        }
      }, _translations.manualMitigationCustomPipelineCreateEditPipelineLink)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  })));
}