"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _fieldUtils = require("@kbn/field-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/field_type_icon/field_type_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FieldTypeIcon = ({
  tooltipEnabled = false,
  type
}) => {
  var _getFieldTypeName;
  const label = (_getFieldTypeName = (0, _fieldUtils.getFieldTypeName)(type)) !== null && _getFieldTypeName !== void 0 ? _getFieldTypeName : _i18n.i18n.translate('xpack.dataVisualizer.fieldTypeIcon.fieldTypeTooltip', {
    defaultMessage: '{type} type',
    values: {
      type
    }
  });
  if (tooltipEnabled === true) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorProps: {
        css: {
          display: 'flex',
          alignItems: 'center'
        }
      },
      content: label,
      "data-test-subj": "dvFieldTypeTooltip",
      position: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: type,
      "data-test-subj": `dvFieldTypeIcon-${type}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: type,
    label: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 10
    }
  });
};
exports.FieldTypeIcon = FieldTypeIcon;