"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/data-views-plugin/public");
var _status_message = require("./status_message");
var _indices_list = require("./indices_list");
var _data_view_editor_service = require("../../data_view_editor_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/preview_panel/preview_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var ViewMode = /*#__PURE__*/function (ViewMode) {
  ViewMode["allIndices"] = "allIndices";
  ViewMode["onlyMatchingIndices"] = "onlyMatchingIndices";
  return ViewMode;
}(ViewMode || {});
const viewModeButtons = [{
  id: ViewMode.allIndices,
  label: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.allSourcesButton', {
    defaultMessage: 'All sources'
  })
}, {
  id: ViewMode.onlyMatchingIndices,
  label: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.matchingSourcesButton', {
    defaultMessage: 'Matching sources'
  })
}];
const PreviewPanel = ({
  type,
  allowHidden,
  title = '',
  matchedIndices$
}) => {
  const [viewMode, setViewMode] = (0, _react.useState)();
  const matched = (0, _useObservable.default)(matchedIndices$, _data_view_editor_service.matchedIndiciesDefault);
  let currentlyVisibleIndices;
  let currentViewMode;
  if (title.length && !isAboutToIncludeMoreIndices(title) && viewMode !== ViewMode.allIndices || viewMode === ViewMode.onlyMatchingIndices) {
    currentlyVisibleIndices = matched.visibleIndices;
    currentViewMode = ViewMode.onlyMatchingIndices;
  } else {
    currentlyVisibleIndices = matched.allIndices;
    currentViewMode = ViewMode.allIndices;
  }
  const indicesListContent = currentlyVisibleIndices.length ? /*#__PURE__*/_react.default.createElement(_indices_list.IndicesList, {
    "data-test-subj": "createIndexPatternStep1IndicesList",
    query: title,
    indices: currentlyVisibleIndices,
    isExactMatch: indexName => title.length > 0 && matched.exactMatchedIndices.some(index => index.name === indexName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_status_message.StatusMessage, {
    matchedIndices: matched,
    showSystemIndices: type === _public.INDEX_PATTERN_TYPE.ROLLUP ? false : true,
    isIncludingSystemIndices: allowHidden,
    query: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), Boolean(title) && (matched.exactMatchedIndices.length > 0 || matched.partialMatchedIndices.length > 0) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('indexPatternEditor.previewPanel.viewModeGroup.legend', {
      defaultMessage: 'Visible sources'
    }),
    options: viewModeButtons,
    idSelected: currentViewMode,
    onChange: id => setViewMode(id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), indicesListContent);
};
exports.PreviewPanel = PreviewPanel;
function isAboutToIncludeMoreIndices(query) {
  return query.trimEnd().endsWith(',');
}