"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfig = exports.configSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configSchema = exports.configSchema = _configSchema.schema.object({
  enabled: _configSchema.schema.boolean({
    defaultValue: false
  }),
  autoops: _configSchema.schema.maybe(_configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: false
    }),
    api: _configSchema.schema.maybe(_configSchema.schema.object({
      url: _configSchema.schema.maybe(_configSchema.schema.uri({
        scheme: ['http', 'https']
      })),
      tls: _configSchema.schema.maybe(_configSchema.schema.object({
        certificate: _configSchema.schema.maybe(_configSchema.schema.string()),
        key: _configSchema.schema.maybe(_configSchema.schema.string())
      }))
    }))
  })),
  /**
   * For internal use. A list of string values (comma delimited) that will enable experimental
   * type of functionality that is not yet released. Valid values for this settings need to
   * be defined in:
   * `x-pack/plugins/dataUsage/common/experimental_features.ts`
   * under the `allowedExperimentalValues` object
   *
   * @example
   * xpack.dataUsage.enableExperimental: ['someFeature']
   */
  enableExperimental: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
    defaultValue: () => []
  })
});
const createConfig = context => {
  const pluginConfig = context.config.get();
  return {
    ...pluginConfig
  };
};
exports.createConfig = createConfig;