"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.urlSchemaRT = exports.isStream = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("./common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStream = value => rt.type({
  dataStream: rt.string,
  view: rt.literal('classic')
}).is(value) || rt.type({
  dataStream: rt.string,
  view: rt.literal('wired')
}).is(value);
exports.isStream = isStream;
const urlSchemaRT = exports.urlSchemaRT = rt.union([
// Case 1: view === 'classic' (classic Streams), dataStream is string
rt.intersection([rt.type({
  dataStream: rt.string,
  view: rt.literal('classic')
}), rt.partial({
  v: rt.literal(2),
  timeRange: _common.timeRangeRT,
  qualityIssuesChart: _common.qualityIssuesRT,
  breakdownField: rt.string,
  qualityIssues: _common.degradedFieldRT,
  expandedQualityIssue: rt.type({
    name: rt.string,
    type: _common.qualityIssuesRT
  }),
  showCurrentQualityIssues: rt.boolean
})]),
// Case 2: view === 'wired' (wired Streams), dataStream is string
rt.intersection([rt.type({
  dataStream: rt.string,
  view: rt.literal('wired')
}), rt.partial({
  v: rt.literal(2),
  timeRange: _common.timeRangeRT,
  qualityIssuesChart: _common.qualityIssuesRT,
  breakdownField: rt.string,
  qualityIssues: _common.degradedFieldRT,
  expandedQualityIssue: rt.type({
    name: rt.string,
    type: _common.qualityIssuesRT
  }),
  showCurrentQualityIssues: rt.boolean
})]),
// Case 3: dataStream is dataStreamRT (data quality app)
rt.intersection([rt.type({
  dataStream: _common.dataStreamRT
}), rt.partial({
  v: rt.literal(2),
  timeRange: _common.timeRangeRT,
  qualityIssuesChart: _common.qualityIssuesRT,
  breakdownField: rt.string,
  qualityIssues: _common.degradedFieldRT,
  expandedQualityIssue: rt.type({
    name: rt.string,
    type: _common.qualityIssuesRT
  }),
  showCurrentQualityIssues: rt.boolean
})])]);