"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpirationStatus = void 0;
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getExpirationStatus = (config, expires) => {
  const tNow = _moment.default.utc().valueOf();
  const tFuture = _moment.default.utc(expires).valueOf();

  // NOTE this could end up negative. If server time is off from the browser's clock
  // and the session was early expired when the browser refreshed the listing
  const durationToExpire = _moment.default.duration(tFuture - tNow);
  const expiresInDays = Math.floor(durationToExpire.asDays());
  const sufficientDays = Math.ceil(_moment.default.duration(config.management.expiresSoonWarning).asDays());
  let toolTipContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.expiresSoonInDays', {
    defaultMessage: 'Expires in {numDays, plural, one {# day} other {# days}}',
    values: {
      numDays: expiresInDays
    }
  });
  let statusContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.expiresSoonInDaysTooltip', {
    defaultMessage: '{numDays, plural, one {# day} other {# days}}',
    values: {
      numDays: expiresInDays
    }
  });
  if (expiresInDays === 0) {
    // switch to show expires in hours
    const expiresInHours = Math.floor(durationToExpire.asHours());
    toolTipContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.expiresSoonInHours', {
      defaultMessage: 'This session expires in {numHours, plural, one {# hour} other {# hours}}',
      values: {
        numHours: expiresInHours
      }
    });
    statusContent = _i18n.i18n.translate('data.mgmt.searchSessions.status.expiresSoonInHoursTooltip', {
      defaultMessage: '{numHours, plural, one {# hour} other {# hours}}',
      values: {
        numHours: expiresInHours
      }
    });
  }
  if (durationToExpire.asMilliseconds() > 0 && expiresInDays <= sufficientDays) {
    return {
      toolTipContent,
      statusContent
    };
  }
};
exports.getExpirationStatus = getExpirationStatus;