"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _common = require("../../../../../../../common");
var _ = require("../..");
var _date_string = require("../../../lib/date_string");
var _get_expiration_status = require("../../../lib/get_expiration_status");
var _2 = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/columns/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getColumns = ({
  core,
  api,
  config,
  timezone,
  onActionComplete,
  kibanaVersion,
  searchUsageCollector
}) => {
  // Use a literal array of table column definitions to detail a UISession object
  return [
  // App
  _2.appIdColumn,
  // Name, links to app and displays the search session data
  {
    ...(0, _2.nameColumn)({
      core,
      searchUsageCollector,
      kibanaVersion
    }),
    width: '20%'
  },
  // # Searches
  {
    field: 'numSearches',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.numSearches', {
      defaultMessage: '# Searches'
    }),
    sortable: true,
    render: (numSearches, session) => /*#__PURE__*/_react.default.createElement(_.TableText, {
      color: "subdued",
      "data-test-subj": "sessionManagementNumSearchesCol",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }, numSearches)
  },
  // Session status
  (0, _2.statusColumn)(timezone),
  // Started date
  {
    field: 'created',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerStarted', {
      defaultMessage: 'Created'
    }),
    sortable: true,
    render: (created, {
      id
    }) => {
      try {
        const startedOn = (0, _date_string.dateString)(created, timezone);
        return /*#__PURE__*/_react.default.createElement(_.TableText, {
          color: "subdued",
          "data-test-subj": "sessionManagementCreatedCol",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 13
          }
        }, startedOn);
      } catch (err) {
        // eslint-disable-next-line no-console
        console.error(err);
        return /*#__PURE__*/_react.default.createElement(_.TableText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 18
          }
        }, created);
      }
    }
  },
  // Expiration date
  {
    field: 'expires',
    name: _i18n.i18n.translate('data.mgmt.searchSessions.table.headerExpiration', {
      defaultMessage: 'Expiration'
    }),
    sortable: true,
    render: (expires, {
      id,
      status
    }) => {
      if (expires && status !== _common.SearchSessionStatus.EXPIRED && status !== _common.SearchSessionStatus.CANCELLED && status !== _common.SearchSessionStatus.ERROR) {
        try {
          const expiresOn = (0, _date_string.dateString)(expires, timezone);

          // return
          return /*#__PURE__*/_react.default.createElement(_.TableText, {
            color: "subdued",
            "data-test-subj": "sessionManagementExpiresCol",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 117,
              columnNumber: 15
            }
          }, expiresOn);
        } catch (err) {
          // eslint-disable-next-line no-console
          console.error(err);
          return /*#__PURE__*/_react.default.createElement(_.TableText, {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 124,
              columnNumber: 20
            }
          }, expires);
        }
      }
      return /*#__PURE__*/_react.default.createElement(_.TableText, {
        color: "subdued",
        "data-test-subj": "sessionManagementExpiresCol",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 11
        }
      }, "--");
    }
  },
  // Highlight Badge, if completed session expires soon
  {
    field: 'status',
    name: '',
    sortable: false,
    render: (status, {
      expires
    }) => {
      const expirationStatus = (0, _get_expiration_status.getExpirationStatus)(config, expires);
      if (expirationStatus) {
        const {
          toolTipContent,
          statusContent
        } = expirationStatus;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: toolTipContent,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          tabIndex: 0,
          color: "warning",
          "data-test-subj": "sessionManagementStatusCol",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 15
          }
        }, statusContent));
      }
      return /*#__PURE__*/_react.default.createElement(_.TableText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 16
        }
      });
    }
  },
  // Action(s) in-line in the row, additional action(s) in the popover, no column header
  (0, _2.actionsColumn)({
    api,
    core,
    onActionComplete
  })];
};
exports.getColumns = getColumns;