"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardGetResultMetaSchema = void 0;
exports.getDashboardAPIGetResultSchema = getDashboardAPIGetResultSchema;
exports.getDashboardGetResultSchema = getDashboardGetResultSchema;
exports.getDashboardListResultAPISchema = getDashboardListResultAPISchema;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getDashboardGetResultSchema() {
  return _configSchema.schema.object({
    item: (0, _common.getDashboardItemSchema)(),
    meta: _configSchema.schema.object({
      outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
      aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
      aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
    }, {
      unknowns: 'forbid'
    })
  }, {
    unknowns: 'forbid'
  });
}
function getDashboardAPIGetResultSchema() {
  return _configSchema.schema.object({
    id: _configSchema.schema.string(),
    type: _configSchema.schema.string(),
    data: (0, _common.getDashboardDataSchema)(),
    meta: _common.dashboardMetaSchema.extends(_common.dashboardResolveMetaSchema)
  }, {
    unknowns: 'forbid'
  });
}
const dashboardGetResultMetaSchema = exports.dashboardGetResultMetaSchema = _common.dashboardMetaSchema.extends(_common.dashboardResolveMetaSchema);
function getDashboardListResultAPISchema() {
  return _configSchema.schema.object({
    items: _configSchema.schema.arrayOf((0, _common.getDashboardAPIItemSchema)()),
    total: _configSchema.schema.number()
  });
}