"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformPanels = transformPanels;
var _std = require("@kbn/std");
var _common = require("../../../common");
var _kibana_services = require("../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function transformPanels(panels, references) {
  function filterReferences(panelId) {
    return !references || !panelId ? undefined : (0, _common.getReferencesForPanelId)(panelId, references);
  }
  return await (0, _std.asyncMap)(panels, async panel => {
    if ((0, _common.isDashboardSection)(panel)) {
      const panelsInSection = await (0, _std.asyncMap)(panel.panels, async panelInSection => {
        return await transformPanel(panelInSection, filterReferences(panelInSection.uid));
      });
      return {
        ...panel,
        panels: panelsInSection
      };
    }
    return await transformPanel(panel, filterReferences(panel.uid));
  });
}
async function transformPanel(panel, references) {
  const transformOut = await _kibana_services.embeddableService.getLegacyURLTransform(panel.type);
  if (!transformOut) return panel;
  try {
    const transformedPanelConfig = transformOut(panel.config, references);
    return {
      ...panel,
      config: transformedPanelConfig
    };
  } catch (transformOutError) {
    // eslint-disable-next-line no-console
    console.warn(`Unable to transform panel state, panelId: ${panel.uid}, error: ${transformOutError}`);
    // do not prevent dashboard render on transform error
    return panel;
  }
}