"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reducer = void 0;
var t = _interopRequireWildcard(require("../action_types"));
var _utils = require("../../services/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  byId: {},
  selectedDetailId: null,
  selectedEditId: null
};
const success = action => `${action}_SUCCESS`;
const parseFollowerIndex = followerIndex => {
  // Extract status into boolean
  return {
    ...followerIndex,
    isPaused: followerIndex.status === 'paused'
  };
};
const reducer = (state = initialState, action) => {
  switch (action.type) {
    case success(t.FOLLOWER_INDEX_LOAD):
      {
        return {
          ...state,
          byId: (0, _utils.arrayToObject)(action.payload.indices.map(parseFollowerIndex), 'name')
        };
      }
    case success(t.FOLLOWER_INDEX_GET):
      {
        return {
          ...state,
          byId: {
            ...state.byId,
            [action.payload.name]: parseFollowerIndex(action.payload)
          }
        };
      }
    case t.FOLLOWER_INDEX_SELECT_DETAIL:
      {
        return {
          ...state,
          selectedDetailId: action.payload
        };
      }
    case t.FOLLOWER_INDEX_SELECT_EDIT:
      {
        return {
          ...state,
          selectedEditId: action.payload
        };
      }
    case success(t.FOLLOWER_INDEX_UNFOLLOW):
      {
        const byId = {
          ...state.byId
        };
        const {
          itemsUnfollowed
        } = action.payload;
        itemsUnfollowed.forEach(id => delete byId[id]);
        return {
          ...state,
          byId
        };
      }
    default:
      return state;
  }
};
exports.reducer = reducer;