"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreRouteHandlerContext = void 0;
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreSavedObjectsServerInternal = require("@kbn/core-saved-objects-server-internal");
var _coreDeprecationsServerInternal = require("@kbn/core-deprecations-server-internal");
var _coreUiSettingsServerInternal = require("@kbn/core-ui-settings-server-internal");
var _coreSecurityServerInternal = require("@kbn/core-security-server-internal");
var _coreUserProfileServerInternal = require("@kbn/core-user-profile-server-internal");
var _coreFeatureFlagsServerInternal = require("@kbn/core-feature-flags-server-internal");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Subset of `InternalCoreStart` used by {@link CoreRouteHandlerContext}
 * @internal
 */
var _featureFlags = /*#__PURE__*/new WeakMap();
var _elasticsearch = /*#__PURE__*/new WeakMap();
var _savedObjects = /*#__PURE__*/new WeakMap();
var _uiSettings = /*#__PURE__*/new WeakMap();
var _deprecations = /*#__PURE__*/new WeakMap();
var _security = /*#__PURE__*/new WeakMap();
var _userProfile = /*#__PURE__*/new WeakMap();
/**
 * The concrete implementation for Core's route handler context.
 *
 * @internal
 */
class CoreRouteHandlerContext {
  constructor(coreStart, request) {
    _classPrivateFieldInitSpec(this, _featureFlags, void 0);
    _classPrivateFieldInitSpec(this, _elasticsearch, void 0);
    _classPrivateFieldInitSpec(this, _savedObjects, void 0);
    _classPrivateFieldInitSpec(this, _uiSettings, void 0);
    _classPrivateFieldInitSpec(this, _deprecations, void 0);
    _classPrivateFieldInitSpec(this, _security, void 0);
    _classPrivateFieldInitSpec(this, _userProfile, void 0);
    this.coreStart = coreStart;
    this.request = request;
  }
  get featureFlags() {
    if (!_classPrivateFieldGet(_featureFlags, this)) {
      _classPrivateFieldSet(_featureFlags, this, new _coreFeatureFlagsServerInternal.CoreFeatureFlagsRouteHandlerContext(this.coreStart.featureFlags));
    }
    return _classPrivateFieldGet(_featureFlags, this);
  }
  get elasticsearch() {
    if (!_classPrivateFieldGet(_elasticsearch, this)) {
      _classPrivateFieldSet(_elasticsearch, this, new _coreElasticsearchServerInternal.CoreElasticsearchRouteHandlerContext(this.coreStart.elasticsearch, this.request));
    }
    return _classPrivateFieldGet(_elasticsearch, this);
  }
  get savedObjects() {
    if (!_classPrivateFieldGet(_savedObjects, this)) {
      _classPrivateFieldSet(_savedObjects, this, new _coreSavedObjectsServerInternal.CoreSavedObjectsRouteHandlerContext(this.coreStart.savedObjects, this.request));
    }
    return _classPrivateFieldGet(_savedObjects, this);
  }
  get uiSettings() {
    if (!_classPrivateFieldGet(_uiSettings, this)) {
      _classPrivateFieldSet(_uiSettings, this, new _coreUiSettingsServerInternal.CoreUiSettingsRouteHandlerContext(this.coreStart.uiSettings, this.savedObjects));
    }
    return _classPrivateFieldGet(_uiSettings, this);
  }
  get deprecations() {
    if (!_classPrivateFieldGet(_deprecations, this)) {
      _classPrivateFieldSet(_deprecations, this, new _coreDeprecationsServerInternal.CoreDeprecationsRouteHandlerContext(this.coreStart.deprecations, this.elasticsearch, this.savedObjects, this.request));
    }
    return _classPrivateFieldGet(_deprecations, this);
  }
  get security() {
    if (!_classPrivateFieldGet(_security, this)) {
      _classPrivateFieldSet(_security, this, new _coreSecurityServerInternal.CoreSecurityRouteHandlerContext(this.coreStart.security, this.request));
    }
    return _classPrivateFieldGet(_security, this);
  }
  get userProfile() {
    if (!_classPrivateFieldGet(_userProfile, this)) {
      _classPrivateFieldSet(_userProfile, this, new _coreUserProfileServerInternal.CoreUserProfileRouteHandlerContext(this.coreStart.userProfile, this.request));
    }
    return _classPrivateFieldGet(_userProfile, this);
  }
}
exports.CoreRouteHandlerContext = CoreRouteHandlerContext;