"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomBrandingService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CustomBrandingService {
  constructor() {
    (0, _defineProperty2.default)(this, "customBranding$", void 0);
    (0, _defineProperty2.default)(this, "stop$", new _rxjs.Subject());
  }
  /**
   * @public
   */
  setup({
    injectedMetadata
  }) {
    const customBranding = injectedMetadata.getCustomBranding();
    this.customBranding$ = new _rxjs.BehaviorSubject(customBranding);
    return {
      customBranding$: this.customBranding$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.shareReplay)(1)),
      hasCustomBranding$: this.customBranding$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.map)(cb => Object.keys(cb).length > 0), (0, _rxjs.shareReplay)(1))
    };
  }

  /**
   * @public
   */
  start() {
    if (!this.customBranding$) {
      throw new Error('Setup needs to be called before start');
    }
    return {
      customBranding$: this.customBranding$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.shareReplay)(1)),
      hasCustomBranding$: this.customBranding$.pipe((0, _rxjs.takeUntil)(this.stop$), (0, _rxjs.map)(cb => Object.keys(cb).length > 0), (0, _rxjs.shareReplay)(1))
    };
  }
  stop() {
    this.stop$.next();
  }
}
exports.CustomBrandingService = CustomBrandingService;