"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.focusFirstElement = void 0;
var _get_focusable_elements = require("./get_focusable_elements");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Utility function for focusing the first interactive element.
 *
 * @param ref - The ref to the container element.
 */
const focusFirstElement = ref => {
  const container = ref === null || ref === void 0 ? void 0 : ref.current;
  if (!container) return;
  const elements = (0, _get_focusable_elements.getFocusableElements)(container);
  if (elements.length > 0) {
    elements[0].focus();
  }
};
exports.focusFirstElement = focusFirstElement;