"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TourManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _tour_config = require("./tour_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const initialState = {
  status: 'idle',
  currentStepIndex: 0,
  steps: _tour_config.tourSteps
};
class TourManager {
  constructor() {
    (0, _defineProperty2.default)(this, "_state$", new _rxjs.BehaviorSubject(initialState));
    (0, _defineProperty2.default)(this, "state$", this._state$.asObservable());
  }
  get state() {
    return this._state$.value;
  }
  startTour() {
    this._state$.next({
      ...this.state,
      currentStepIndex: 0,
      status: 'waiting'
    });
  }
  activateTour(visibleStepIds) {
    const currentState = this._state$.value;
    if (currentState.status !== 'waiting') return;
    const visibleSteps = currentState.steps.filter(step => visibleStepIds.includes(step.id));
    this._state$.next({
      ...currentState,
      steps: visibleSteps,
      status: 'active'
    });
  }
  async waitForTourEnd() {
    return (0, _rxjs.firstValueFrom)(this.state$.pipe((0, _rxjs.first)(state => state.status === 'completed' || state.status === 'skipped'), (0, _rxjs.map)(state => state.status)));
  }
  nextStep() {
    const currentState = this._state$.value;
    if (currentState.status !== 'active') return;
    const nextIndex = currentState.currentStepIndex + 1;
    if (nextIndex >= currentState.steps.length) {
      this.finishTour();
    } else {
      this._state$.next({
        ...currentState,
        currentStepIndex: nextIndex
      });
    }
  }
  skipTour() {
    const currentState = this._state$.value;
    this._state$.next({
      ...currentState,
      status: 'skipped'
    });
  }
  finishTour() {
    const currentState = this._state$.value;
    this._state$.next({
      ...currentState,
      status: 'completed'
    });
  }
  reset() {
    this._state$.next(initialState);
  }
}
exports.TourManager = TourManager;