"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutConfigProvider = void 0;
exports.useLayoutConfig = useLayoutConfig;
exports.useLayoutUpdate = useLayoutUpdate;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/layout_config_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Configuration for the layout.
 * @public
 */

/**
 * Context interface including both the config and an update function
 * @internal
 */

const LayoutConfigContext = /*#__PURE__*/(0, _react.createContext)(undefined);

/**
 * Props for the LayoutConfigProvider component.
 * @public
 */

/**
 * Provider of the layout config
 * @public
 */
const LayoutConfigProvider = ({
  value: initialValue,
  children
}) => {
  const [config, setConfig] = (0, _react.useState)(initialValue);

  // Reset state when initialValue changes, but only for fields that have changed
  (0, _react.useEffect)(() => {
    setConfig(prevConfig => {
      const changedFields = getChangedFields(prevConfig, initialValue);

      // Only update if there are any changed fields
      if (Object.keys(changedFields).length > 0) {
        return {
          ...prevConfig,
          ...changedFields
        };
      }
      return prevConfig;
    });
  }, [initialValue]);
  const updateLayout = (0, _react.useCallback)(updates => {
    setConfig(prevConfig => {
      const changedFields = getChangedFields(prevConfig, updates);

      // Only update if there are any changed fields
      if (Object.keys(changedFields).length > 0) {
        return {
          ...prevConfig,
          ...changedFields
        };
      }
      return prevConfig;
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(LayoutConfigContext.Provider, {
    value: {
      config,
      updateLayout
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, children);
};

/**
 * Hook to access the layout configuration.
 * @internal
 * @returns The current layout configuration
 * @throws Error if used outside of a LayoutConfigProvider
 */
exports.LayoutConfigProvider = LayoutConfigProvider;
function useLayoutConfig() {
  const context = (0, _react.useContext)(LayoutConfigContext);
  if (!context) {
    throw new Error('useLayoutConfig must be used within a LayoutConfigProvider');
  }
  return context.config;
}

/**
 * Hook to access and update the layout configuration.
 * @public
 * @returns a function to update it
 * @throws Error if used outside of a LayoutConfigProvider
 */
function useLayoutUpdate() {
  const context = (0, _react.useContext)(LayoutConfigContext);
  if (!context) {
    throw new Error('useLayoutConfigUpdate must be used within a LayoutConfigProvider');
  }
  return context.updateLayout;
}

/**
 * Utility function to extract only changed fields between two objects
 * @internal
 */
function getChangedFields(current, updates) {
  return Object.entries(updates).reduce((acc, [key, value]) => {
    const typedKey = key;
    if (current[typedKey] !== value) {
      acc[typedKey] = value;
    }
    return acc;
  }, {});
}