"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTitleService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultTitle = [];
const titleSeparator = ' - ';

/** @internal */
class DocTitleService {
  constructor() {
    (0, _defineProperty2.default)(this, "document", void 0);
    (0, _defineProperty2.default)(this, "baseTitle", void 0);
    (0, _defineProperty2.default)(this, "titleSubject", new _rxjs.ReplaySubject(1));
  }
  setup({
    document
  }) {
    this.document = document;
    this.baseTitle = document.title;
    this.titleSubject.next(this.baseTitle);
    return {
      title$: this.titleSubject.asObservable().pipe((0, _rxjs.distinctUntilChanged)())
    };
  }
  start() {
    if (this.document === undefined || this.baseTitle === undefined) {
      throw new Error('DocTitleService#setup must be called before DocTitleService#start');
    }
    return {
      change: title => {
        this.applyTitle(title);
      },
      reset: () => {
        this.applyTitle(defaultTitle);
      }
    };
  }
  applyTitle(title) {
    const rendered = this.render(title);
    this.document.title = rendered;
    this.titleSubject.next(rendered);
  }
  render(title) {
    const parts = [...((0, _lodash.isString)(title) ? [title] : title), this.baseTitle];
    // ensuring compat with legacy that might be passing nested arrays
    return (0, _lodash.compact)((0, _lodash.flattenDeep)(parts)).join(titleSeparator);
  }
}
exports.DocTitleService = DocTitleService;