"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _es_config = require("./api/console/es_config");
var _proxy = require("./api/console/proxy");
var _spec_definitions = require("./api/console/spec_definitions");
var _autocomplete_entities = require("./api/console/autocomplete_entities");
var _convert_request_to_language = require("./api/console/convert_request_to_language");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registerRoutes = dependencies => {
  (0, _es_config.registerEsConfigRoute)(dependencies);
  (0, _proxy.registerProxyRoute)(dependencies);
  (0, _spec_definitions.registerSpecDefinitionsRoute)(dependencies);
  (0, _autocomplete_entities.registerAutocompleteEntitiesRoute)(dependencies);
  (0, _convert_request_to_language.registerConvertRequestRoute)(dependencies);
};
exports.registerRoutes = registerRoutes;