"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.coreContext = void 0;
Object.defineProperty(exports, "createCoreContext", {
  enumerable: true,
  get: function () {
    return _core_context.createCoreContext;
  }
});
Object.defineProperty(exports, "createInjectedMetadata", {
  enumerable: true,
  get: function () {
    return _injected_metadata.createInjectedMetadata;
  }
});
Object.defineProperty(exports, "createTrackUiMetric", {
  enumerable: true,
  get: function () {
    return _track_ui_metric.createTrackUiMetric;
  }
});
exports.trackUiMetric = exports.injectedMetadata = void 0;
var _injected_metadata = require("./injected_metadata");
var _core_context = require("./core_context");
var _track_ui_metric = require("./track_ui_metric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Export factory functions and types

// Import factory functions for service initialization

// Initialize and export service instances
const coreContext = exports.coreContext = (0, _core_context.createCoreContext)({
  version: '1.0.0',
  branch: 'main',
  buildNum: 1,
  buildSha: 'prod-build',
  buildShaShort: 'prod',
  mode: 'production',
  enableConsoleLogging: true
});
const injectedMetadata = exports.injectedMetadata = (0, _injected_metadata.createInjectedMetadata)({
  kibanaBranch: 'main',
  kibanaVersion: '9.3.0',
  kibanaBuildNumber: 12345
});
const trackUiMetric = exports.trackUiMetric = (0, _track_ui_metric.createTrackUiMetric)();