"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.postFileRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _mimeTypes = _interopRequireDefault(require("mime-types"));
var _path = require("path");
var _configSchema = require("@kbn/config-schema");
var _rxjs = require("rxjs");
var _errors = require("@kbn/files-plugin/server/file/errors");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const postFileRoute = exports.postFileRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.CASE_FILES_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'public',
    summary: 'Attach a file to a case',
    tags: ['oas-tag:cases'],
    body: {
      // This is set to 10 GiB as an upper boundary on the size of the HTTP request body.
      // The file service will throw 413 errors if the file size is larger than expected.
      maxBytes: 10 * 1024 * 1024 * 1024,
      output: 'stream',
      parse: true,
      accepts: 'multipart/form-data'
    }
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    const $abort = new _rxjs.ReplaySubject();
    const sub = request.events.aborted$.subscribe($abort);
    try {
      var _filename;
      const caseContext = await context.cases;
      const casesClient = await caseContext.getCasesClient();
      const fileRequest = request.body;
      const file = fileRequest.file;
      let filename = fileRequest.filename;
      let mimeType;
      if (file.hapi != null) {
        const parsedFilename = (0, _path.parse)(file.hapi.filename);
        filename ??= parsedFilename.name;
        mimeType = _mimeTypes.default.lookup(parsedFilename.ext.toLowerCase()) || undefined;
      }
      const res = await casesClient.attachments.addFile({
        file,
        filename: (_filename = filename) !== null && _filename !== void 0 ? _filename : '',
        mimeType,
        caseId: request.params.case_id,
        $abort
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      if (error instanceof _errors.AbortedUploadError) {
        throw new _boom.default.Boom(error, {
          statusCode: 499,
          message: error.message
        });
      }
      throw (0, _error.createCaseError)({
        message: `Failed to attach file to case in route: ${error}`,
        error
      });
    } finally {
      sub.unsubscribe();
    }
  }
});