"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getReportersRoute = void 0;
var _constants = require("../../../../../common/constants");
var _error = require("../../../../common/error");
var _create_cases_route = require("../../create_cases_route");
var _constants2 = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getReportersRoute = exports.getReportersRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_REPORTERS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  routerOptions: {
    access: 'public',
    summary: `Get case creators`,
    tags: ['oas-tag:cases']
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const options = request.query;
      const res = await client.cases.getReporters({
        ...options
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to find cases in route: ${error}`,
        error
      });
    }
  }
});