"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulerTaskRunner = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../utils");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SchedulerTaskRunner {
  constructor({
    getUnsecureSavedObjectsClient,
    logger,
    analyticsConfig,
    getTaskManager,
    getESClient
  }) {
    (0, _defineProperty2.default)(this, "getUnsecureSavedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "analyticsConfig", void 0);
    (0, _defineProperty2.default)(this, "getTaskManager", void 0);
    (0, _defineProperty2.default)(this, "getESClient", void 0);
    this.getUnsecureSavedObjectsClient = getUnsecureSavedObjectsClient;
    this.logger = logger;
    this.analyticsConfig = analyticsConfig;
    this.getTaskManager = getTaskManager;
    this.getESClient = getESClient;
  }
  async run() {
    if (!this.analyticsConfig.index.enabled) {
      this.logger.debug('Analytics index is disabled, skipping scheduler task.');
      return;
    }
    try {
      const unsecureSavedObjectsClient = await this.getUnsecureSavedObjectsClient();
      const spaces = await (0, _utils.getAllSpacesWithCases)(unsecureSavedObjectsClient);
      const taskManager = await this.getTaskManager();
      const esClient = await this.getESClient();
      for (const spaceId of spaces) {
        const indices = (0, _.getIndicesForSpaceId)(spaceId);
        const destIndicesExist = await esClient.indices.exists({
          index: indices
        });
        if (!destIndicesExist) {
          // Create the necessary analytics indexes without scheduling the sync tasks
          (0, _.createCasesAnalyticsIndexesForSpaceId)({
            spaceId,
            esClient,
            logger: this.logger,
            isServerless: false,
            taskManager
          }).catch(() => {
            this.logger.error(`Failed to create analytics indexes for space ${spaceId}`);
          });
        } else {
          (0, _.scheduleCasesAnalyticsSyncTasks)({
            spaceId,
            taskManager,
            logger: this.logger
          });
        }
      }
    } catch (error) {
      this.logger.error(`Error occurred while running case analytics scheduler task: ${error.message}`);
    }
  }
  async cancel() {
    this.logger.debug('Cancelling case analytics scheduler task.');
  }
}
exports.SchedulerTaskRunner = SchedulerTaskRunner;