"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCasesAnalyticsIndexes = void 0;
exports.createCasesAnalyticsIndexesForSpaceId = createCasesAnalyticsIndexesForSpaceId;
exports.scheduleCasesAnalyticsSyncTasks = exports.registerCasesAnalyticsIndexesTasks = exports.getIndicesForSpaceId = void 0;
var _constants = require("../../common/constants");
var _backfill_task = require("./tasks/backfill_task");
var _synchronization_task = require("./tasks/synchronization_task");
var _attachments_index = require("./attachments_index");
var _cases_index = require("./cases_index");
var _comments_index = require("./comments_index");
var _activity_index = require("./activity_index");
var _utils = require("./utils");
var _scheduler_task = require("./tasks/scheduler_task");
var _constants2 = require("./activity_index/constants");
var _constants3 = require("./attachments_index/constants");
var _constants4 = require("./cases_index/constants");
var _constants5 = require("./comments_index/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCasesAnalyticsIndexes = async ({
  esClient,
  logger,
  isServerless,
  taskManager,
  savedObjectsClient
}) => {
  const spaces = await (0, _utils.getAllSpacesWithCases)(savedObjectsClient);
  for (const spaceId of spaces) {
    try {
      await createCasesAnalyticsIndexesForSpaceId({
        spaceId,
        esClient,
        logger,
        isServerless,
        taskManager
      });
      logger.info(`Successfully created cases analytics indexes for space ${spaceId}`);
    } catch (error) {
      logger.error(`Error creating cases analytics indexes for space ${spaceId}: ${error}`);
    }
  }
};
exports.createCasesAnalyticsIndexes = createCasesAnalyticsIndexes;
async function createCasesAnalyticsIndexesForSpaceId({
  esClient,
  logger,
  isServerless,
  taskManager,
  spaceId
}) {
  return Promise.all(_constants.OWNERS.reduce((operations, owner) => {
    const casesIndex = (0, _cases_index.createCasesAnalyticsIndex)({
      logger,
      esClient,
      isServerless,
      taskManager,
      spaceId,
      owner
    });
    const casesCommentsIndex = (0, _comments_index.createCommentsAnalyticsIndex)({
      logger,
      esClient,
      isServerless,
      taskManager,
      spaceId,
      owner
    });
    const casesAttachmentsIndex = (0, _attachments_index.createAttachmentsAnalyticsIndex)({
      logger,
      esClient,
      isServerless,
      taskManager,
      spaceId,
      owner
    });
    const casesActivityIndex = (0, _activity_index.createActivityAnalyticsIndex)({
      logger,
      esClient,
      isServerless,
      taskManager,
      spaceId,
      owner
    });
    return operations.concat([casesIndex.upsertIndex(), casesCommentsIndex.upsertIndex(), casesAttachmentsIndex.upsertIndex(), casesActivityIndex.upsertIndex()]);
  }, []));
}
const registerCasesAnalyticsIndexesTasks = ({
  taskManager,
  logger,
  core,
  analyticsConfig
}) => {
  (0, _backfill_task.registerCAIBackfillTask)({
    taskManager,
    logger,
    core,
    analyticsConfig
  });
  (0, _scheduler_task.registerCAISchedulerTask)({
    taskManager,
    logger,
    core,
    analyticsConfig
  });
  (0, _synchronization_task.registerCAISynchronizationTask)({
    taskManager,
    logger,
    core,
    analyticsConfig
  });
};
exports.registerCasesAnalyticsIndexesTasks = registerCasesAnalyticsIndexesTasks;
const scheduleCasesAnalyticsSyncTasks = ({
  taskManager,
  logger,
  spaceId
}) => {
  for (const owner of _constants.OWNERS) {
    void (0, _synchronization_task.scheduleCAISynchronizationTask)({
      taskManager,
      logger,
      spaceId,
      owner
    });
  }
};
exports.scheduleCasesAnalyticsSyncTasks = scheduleCasesAnalyticsSyncTasks;
const getIndicesForSpaceId = spaceId => {
  return _constants.OWNERS.reduce((curr, owner) => {
    return curr.concat([(0, _constants2.getActivityDestinationIndexName)(spaceId, owner), (0, _constants3.getAttachmentsDestinationIndexName)(spaceId, owner), (0, _constants4.getCasesDestinationIndexName)(spaceId, owner), (0, _constants5.getCommentsDestinationIndexName)(spaceId, owner)]);
  }, []);
};
exports.getIndicesForSpaceId = getIndicesForSpaceId;