"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumberFieldConfig = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _helpers.fieldValidators;
const getNumberFieldConfig = ({
  required,
  label,
  defaultValue
}) => {
  const validators = [];
  if (required) {
    validators.push({
      validator: emptyField((0, _translations.REQUIRED_FIELD)(label))
    });
  }
  return {
    ...(defaultValue && {
      defaultValue
    }),
    validations: [...validators, {
      validator: ({
        value
      }) => {
        if (value == null) {
          return;
        }
        const numericValue = Number(value);
        if (!Number.isSafeInteger(numericValue)) {
          return {
            message: (0, _translations.SAFE_INTEGER_NUMBER_ERROR)(label)
          };
        }
      }
    }]
  };
};
exports.getNumberFieldConfig = getNumberFieldConfig;