"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAutoImportIntegrationRequestParams = exports.UpdateAutoImportIntegrationRequestBody = exports.CreateAutoImportIntegrationResponse = exports.CreateAutoImportIntegrationRequestBody = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("../primitive.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Integrations API endpoint
 *   version: 1
 */

const CreateAutoImportIntegrationRequestBody = exports.CreateAutoImportIntegrationRequestBody = _zod.z.object({
  /**
   * The integration title
   */
  title: _primitive.NonEmptyString,
  /**
   * The integration description
   */
  description: _zod.z.string().optional(),
  /**
   * The integration logo
   */
  logo: _zod.z.string().optional()
}).strict();
const CreateAutoImportIntegrationResponse = exports.CreateAutoImportIntegrationResponse = _zod.z.object({
  /**
   * The integration id created in state.
   */
  integration_id: _primitive.NonEmptyString
});
const UpdateAutoImportIntegrationRequestParams = exports.UpdateAutoImportIntegrationRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString
});
const UpdateAutoImportIntegrationRequestBody = exports.UpdateAutoImportIntegrationRequestBody = _zod.z.object({
  /**
   * Integration description
   */
  description: _zod.z.string().optional(),
  /**
   * Integration logo image blob
   */
  logo: _zod.z.string().optional()
}).strict();