"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateAutoImportDataStreamRequestParams = exports.UpdateAutoImportDataStreamRequestBody = exports.CreateAutoImportDataStreamResponse = exports.CreateAutoImportDataStreamRequestParams = exports.CreateAutoImportDataStreamRequestBody = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("../primitive.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Data Streams API endpoint
 *   version: 1
 */

const CreateAutoImportDataStreamRequestParams = exports.CreateAutoImportDataStreamRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString
});
const CreateAutoImportDataStreamRequestBody = exports.CreateAutoImportDataStreamRequestBody = _zod.z.object({
  /**
   * The data stream title
   */
  title: _primitive.NonEmptyString,
  /**
   * The data stream description
   */
  description: _zod.z.string().optional(),
  /**
   * The data stream samples
   */
  samples: _zod.z.array(_zod.z.string()).min(1)
}).strict();
const CreateAutoImportDataStreamResponse = exports.CreateAutoImportDataStreamResponse = _zod.z.object({
  /**
   * The data stream id created in state.
   */
  data_stream_id: _primitive.NonEmptyString
});
const UpdateAutoImportDataStreamRequestParams = exports.UpdateAutoImportDataStreamRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString,
  /**
   * The data stream identifier
   */
  data_stream_id: _primitive.NonEmptyString
});
const UpdateAutoImportDataStreamRequestBody = exports.UpdateAutoImportDataStreamRequestBody = _zod.z.object({
  /**
   * Data stream description
   */
  description: _zod.z.string().optional(),
  /**
   * Data stream samples
   */
  samples: _zod.z.array(_zod.z.string()).min(1).optional()
}).strict();