"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FocusedTraceWaterfall = FocusedTraceWaterfall;
exports.flattenChildren = flattenChildren;
exports.reparentDocumentToRoot = reparentDocumentToRoot;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _trace_waterfall = require("../trace_waterfall");
var _trace_summary = require("./trace_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/focused_trace_waterfall/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function flattenChildren(children) {
  function convert(child) {
    var _child$children;
    const convertedChildren = (_child$children = child.children) !== null && _child$children !== void 0 && _child$children.length ? child.children.flatMap(convert) : [];
    return [child.traceDoc, ...convertedChildren];
  }
  return children.flatMap(convert);
}
function reparentDocumentToRoot(items) {
  var _clonedItems$parentDo;
  if (!items) {
    return undefined;
  }
  const clonedItems = structuredClone(items);
  const rootDocId = clonedItems.rootDoc.id;
  if (rootDocId === clonedItems.focusedTraceDoc.id || rootDocId === ((_clonedItems$parentDo = clonedItems.parentDoc) === null || _clonedItems$parentDo === void 0 ? void 0 : _clonedItems$parentDo.id)) {
    return clonedItems;
  }
  if (clonedItems.parentDoc) {
    clonedItems.parentDoc.parentId = rootDocId;
  } else {
    clonedItems.focusedTraceDoc.parentId = rootDocId;
  }
  return clonedItems;
}
function getTraceItems(items) {
  var _items$parentDoc;
  const children = items.focusedTraceTree || [];
  const childrenItems = flattenChildren(children);
  const traceItems = [items.rootDoc, ((_items$parentDoc = items.parentDoc) === null || _items$parentDoc === void 0 ? void 0 : _items$parentDoc.id) === items.rootDoc.id ? undefined : items.parentDoc, items.focusedTraceDoc.id === items.rootDoc.id ? undefined : items.focusedTraceDoc, ...childrenItems].filter(Boolean);
  return traceItems;
}
function FocusedTraceWaterfall({
  items,
  onErrorClick,
  isEmbeddable
}) {
  const reparentedItems = reparentDocumentToRoot(items.traceItems);
  const traceItems = reparentedItems ? getTraceItems(reparentedItems) : [];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_trace_waterfall.TraceWaterfall, {
    traceItems: traceItems,
    showAccordion: false,
    highlightedTraceId: reparentedItems === null || reparentedItems === void 0 ? void 0 : reparentedItems.focusedTraceDoc.id,
    onErrorClick: onErrorClick,
    isEmbeddable: isEmbeddable,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), reparentedItems ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_trace_summary.TraceSummary, {
    summary: items.summary,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  })) : null);
}