"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Schema = Schema;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _use_local_storage = require("../../../../hooks/use_local_storage");
var _schema_overview = require("./schema_overview");
var _confirm_switch_modal = require("./confirm_switch_modal");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/schema/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const APM_DATA_STREAMS_MIGRATION_STATUS_LS = {
  value: '',
  expiry: ''
};
function Schema() {
  const [apmDataStreamsMigrationStatus, setApmDataStreamsMigrationStatus] = (0, _use_local_storage.useLocalStorage)('apm.dataStreamsMigrationStatus', APM_DATA_STREAMS_MIGRATION_STATUS_LS);
  const {
    toasts
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core.notifications;
  const [isSwitchActive, setIsSwitchActive] = (0, _react.useState)(false);
  const [isLoadingConfirmation, setIsLoadingConfirmation] = (0, _react.useState)(false);
  const [unsupportedConfigs, setUnsupportedConfigs] = (0, _react.useState)([]);
  const {
    refetch,
    data = {},
    status
  } = (0, _use_fetcher.useFetcher)(callApi => callApi('GET /internal/apm/fleet/migration_check'), [], {
    preservePreviousData: false
  });
  const isLoading = status !== _use_fetcher.FETCH_STATUS.SUCCESS;
  const cloudApmMigrationEnabled = !!data.cloud_apm_migration_enabled;
  const hasCloudAgentPolicy = !!data.has_cloud_agent_policy;
  const cloudApmPackagePolicy = data.cloud_apm_package_policy;
  const hasCloudApmPackagePolicy = !!cloudApmPackagePolicy;
  const hasRequiredRole = !!data.has_required_role;
  const latestApmPackageVersion = data.latest_apm_package_version;
  function updateLocalStorage(newStatus) {
    setApmDataStreamsMigrationStatus({
      value: newStatus,
      expiry: (0, _moment.default)().add(5, 'minutes').toISOString()
    });
  }
  const {
    value: localStorageValue,
    expiry
  } = apmDataStreamsMigrationStatus;
  const isMigrating = localStorageValue === _use_fetcher.FETCH_STATUS.LOADING && (0, _moment.default)(expiry).valueOf() > _moment.default.now();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_schema_overview.SchemaOverview, {
    onSwitch: async () => {
      setIsLoadingConfirmation(true);
      const unsupported = await getUnsupportedApmServerConfigs(toasts);
      if (!unsupported) {
        setIsLoadingConfirmation(false);
        return;
      }
      setUnsupportedConfigs(unsupported);
      setIsLoadingConfirmation(false);
      setIsSwitchActive(true);
    },
    isMigrating: isMigrating,
    isMigrated: hasCloudApmPackagePolicy,
    isLoading: isLoading,
    isLoadingConfirmation: isLoadingConfirmation,
    cloudApmMigrationEnabled: cloudApmMigrationEnabled,
    hasCloudAgentPolicy: hasCloudAgentPolicy,
    hasRequiredRole: hasRequiredRole,
    cloudApmPackagePolicy: cloudApmPackagePolicy,
    latestApmPackageVersion: latestApmPackageVersion,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), isSwitchActive && /*#__PURE__*/_react.default.createElement(_confirm_switch_modal.ConfirmSwitchModal, {
    onConfirm: async () => {
      setIsSwitchActive(false);
      const apmPackagePolicy = await createCloudApmPackagePolicy(toasts, updateLocalStorage);
      if (!apmPackagePolicy) {
        return;
      }
      refetch();
    },
    onCancel: () => {
      setIsSwitchActive(false);
    },
    unsupportedConfigs: unsupportedConfigs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }));
}
async function getUnsupportedApmServerConfigs(toasts) {
  try {
    const {
      unsupported
    } = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/fleet/apm_server_schema/unsupported', {
      signal: null
    });
    return unsupported;
  } catch (error) {
    var _error$body;
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.settings.unsupportedConfigs.errorToast.title', {
        defaultMessage: 'Unable to fetch APM Server settings'
      }),
      text: ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message
    });
  }
}
async function createCloudApmPackagePolicy(toasts, updateLocalStorage) {
  updateLocalStorage(_use_fetcher.FETCH_STATUS.LOADING);
  try {
    const {
      cloudApmPackagePolicy
    } = await (0, _create_call_apm_api.callApmApi)('POST /internal/apm/fleet/cloud_apm_package_policy', {
      signal: null
    });
    updateLocalStorage(_use_fetcher.FETCH_STATUS.SUCCESS);
    return cloudApmPackagePolicy;
  } catch (error) {
    var _error$body2;
    updateLocalStorage(_use_fetcher.FETCH_STATUS.FAILURE);
    toasts.addDanger({
      title: _i18n.i18n.translate('xpack.apm.settings.createApmPackagePolicy.errorToast.title', {
        defaultMessage: 'Unable to create APM package policy on cloud agent policy'
      }),
      text: ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) || error.message
    });
  }
}