"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleTypesInternalRoute = void 0;
var _internal = require("../../../../../../common/routes/rule/apis/list_types/internal");
var _lib = require("../../../../lib");
var _types = require("../../../../../types");
var _transforms = require("./transforms");
var _constants = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleTypesInternalRoute = (router, licenseState) => {
  router.get({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/_rule_types`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      request: {},
      response: {
        200: {
          body: () => _internal.getRuleTypesInternalResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        401: {
          description: 'Authorization information is missing or invalid.'
        }
      }
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const rulesClient = await (await context.alerting).getRulesClient();
    const ruleTypes = await rulesClient.listRuleTypes();
    const responseBody = (0, _transforms.transformRuleTypesInternalResponseV1)(ruleTypes);
    return res.ok({
      body: responseBody
    });
  })));
};
exports.getRuleTypesInternalRoute = getRuleTypesInternalRoute;