"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findBackfill = findBackfill;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _esQuery = require("@kbn/es-query");
var _common = require("../../../../rules_client/common");
var _saved_objects = require("../../../../saved_objects");
var _authorization = require("../../../../authorization");
var _audit_events = require("../../../../rules_client/common/audit_events");
var _schemas = require("./schemas");
var _transforms = require("../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findBackfill(context, params) {
  try {
    var _ref;
    try {
      _schemas.findBackfillQuerySchema.validate(params);
    } catch (error) {
      throw new Error(`Could not validate find parameters "${JSON.stringify(params)}" - ${error.message}`);
    }
    let authorizationTuple;
    try {
      authorizationTuple = await context.authorization.getFindAuthorizationFilter({
        authorizationEntity: _authorization.AlertingAuthorizationEntity.Rule,
        filterOpts: {
          type: _authorization.AlertingAuthorizationFilterType.KQL,
          fieldNames: {
            ruleTypeId: 'ad_hoc_run_params.attributes.rule.alertTypeId',
            consumer: 'ad_hoc_run_params.attributes.rule.consumer'
          }
        }
      });
    } catch (error) {
      var _context$auditLogger;
      (_context$auditLogger = context.auditLogger) === null || _context$auditLogger === void 0 ? void 0 : _context$auditLogger.log((0, _audit_events.adHocRunAuditEvent)({
        action: _audit_events.AdHocRunAuditAction.FIND,
        error
      }));
      throw error;
    }

    // Build options based on params
    const hasReferenceArray = [];
    if (params.ruleIds) {
      const ruleIds = params.ruleIds.split(',');
      (ruleIds !== null && ruleIds !== void 0 ? ruleIds : []).forEach(ruleId => {
        hasReferenceArray.push({
          id: ruleId,
          type: _saved_objects.RULE_SAVED_OBJECT_TYPE
        });
      });
    }
    const timeFilters = [];
    if (params.start) {
      timeFilters.push(`ad_hoc_run_params.attributes.start >= "${params.start}"`);
    }
    if (params.end) {
      timeFilters.push(`ad_hoc_run_params.attributes.end <= "${params.end}"`);
    }
    const timeFilter = timeFilters.length > 0 ? timeFilters.join(` AND `) : undefined;
    const filterKueryNode = (0, _common.buildKueryNodeFilter)(timeFilter);
    const {
      filter: authorizationFilter
    } = authorizationTuple;
    const {
      page,
      per_page: perPage,
      total,
      saved_objects: data
    } = await context.unsecuredSavedObjectsClient.find({
      type: _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE,
      page: params.page,
      perPage: params.perPage,
      filter: (_ref = authorizationFilter && filterKueryNode ? _esQuery.nodeBuilder.and([filterKueryNode, authorizationFilter]) : authorizationFilter) !== null && _ref !== void 0 ? _ref : filterKueryNode,
      ...(hasReferenceArray.length > 0 ? {
        hasReference: hasReferenceArray
      } : {}),
      ...(params.sortField ? {
        sortField: params.sortField
      } : {}),
      ...(params.sortOrder ? {
        sortOrder: params.sortOrder
      } : {})
    });
    const actionsClient = await context.getActionsClient();
    const transformedData = data.map(so => {
      var _context$auditLogger2;
      (_context$auditLogger2 = context.auditLogger) === null || _context$auditLogger2 === void 0 ? void 0 : _context$auditLogger2.log((0, _audit_events.adHocRunAuditEvent)({
        action: _audit_events.AdHocRunAuditAction.FIND,
        savedObject: {
          type: _saved_objects.AD_HOC_RUN_SAVED_OBJECT_TYPE,
          id: so.id,
          name: `backfill for rule "${so.attributes.rule.name}"`
        }
      }));
      return (0, _transforms.transformAdHocRunToBackfillResult)({
        adHocRunSO: so,
        isSystemAction: id => actionsClient.isSystemAction(id)
      });
    });
    return {
      page,
      perPage,
      total,
      data: transformedData
    };
  } catch (err) {
    const errorMessage = `Failed to find backfills`;
    context.logger.error(`${errorMessage} - ${err}`);
    throw _boom.default.boomify(err, {
      message: errorMessage
    });
  }
}