"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActionsPopover = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../translations"));
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/table_actions_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TableActionsPopover = exports.TableActionsPopover = /*#__PURE__*/_react.default.memo(({
  id,
  status,
  isLoading,
  onEdit,
  onCancel,
  onArchive,
  onCancelAndArchive,
  onDelete
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const [modalType, setModalType] = (0, _react.useState)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const onButtonClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const closeModal = (0, _react.useCallback)(() => setIsModalVisible(false), []);
  const showModal = (0, _react.useCallback)(type => {
    setModalType(type);
    setIsModalVisible(true);
  }, []);
  const modal = (0, _react.useMemo)(() => {
    const modals = {
      cancel: {
        props: {
          title: i18n.CANCEL_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onCancel(id);
          },
          cancelButtonText: i18n.CANCEL_MODAL_BUTTON,
          confirmButtonText: i18n.CANCEL_MODAL_TITLE
        },
        subtitle: i18n.CANCEL_MODAL_SUBTITLE
      },
      cancelAndArchive: {
        props: {
          title: i18n.CANCEL_AND_ARCHIVE_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onCancelAndArchive(id);
          },
          cancelButtonText: i18n.CANCEL_MODAL_BUTTON,
          confirmButtonText: i18n.CANCEL_AND_ARCHIVE_MODAL_TITLE
        },
        subtitle: i18n.CANCEL_AND_ARCHIVE_MODAL_SUBTITLE
      },
      archive: {
        props: {
          title: i18n.ARCHIVE_TITLE,
          onConfirm: () => {
            closeModal();
            onArchive(id, true);
          },
          cancelButtonText: i18n.CANCEL,
          confirmButtonText: i18n.ARCHIVE_TITLE
        },
        subtitle: i18n.ARCHIVE_SUBTITLE
      },
      unarchive: {
        props: {
          title: i18n.UNARCHIVE_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onArchive(id, false);
          },
          cancelButtonText: i18n.CANCEL,
          confirmButtonText: i18n.UNARCHIVE_MODAL_TITLE
        },
        subtitle: i18n.UNARCHIVE_MODAL_SUBTITLE
      },
      delete: {
        props: {
          title: i18n.DELETE_MODAL_TITLE,
          onConfirm: () => {
            closeModal();
            onDelete(id);
          },
          cancelButtonText: i18n.CANCEL,
          confirmButtonText: i18n.DELETE_MODAL_TITLE
        },
        subtitle: i18n.DELETE_MODAL_SUBTITLE
      }
    };
    let m;
    if (isModalVisible && modalType) {
      const modalProps = modals[modalType];
      m = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({}, modalProps.props, {
        style: {
          width: 600
        },
        onCancel: closeModal,
        defaultFocusedButton: "confirm",
        buttonColor: "danger",
        "aria-labelledby": modalTitleId,
        titleProps: {
          id: modalTitleId
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 13
        }
      }, modalProps.subtitle));
    }
    return m;
  }, [id, modalType, isModalVisible, closeModal, onArchive, onCancel, onCancelAndArchive, onDelete, modalTitleId]);
  const items = (0, _react.useMemo)(() => {
    const menuItems = {
      edit: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-edit",
        key: "edit",
        icon: "pencil",
        onClick: () => {
          closePopover();
          onEdit(id);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 11
        }
      }, i18n.TABLE_ACTION_EDIT),
      copyId: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-copy-id",
        key: "copy-id",
        icon: "copyClipboard",
        onClick: () => {
          closePopover();
          navigator.clipboard.writeText(id).then(() => {
            toasts.addSuccess(i18n.COPY_ID_ACTION_SUCCESS);
          });
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 11
        }
      }, i18n.COPY_ID),
      cancel: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-cancel",
        key: "cancel",
        icon: "stopSlash",
        onClick: () => {
          closePopover();
          showModal('cancel');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }, i18n.TABLE_ACTION_CANCEL),
      cancelAndArchive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-cancel-and-archive",
        key: "cancel-and-archive",
        icon: "folderOpen",
        onClick: () => {
          closePopover();
          showModal('cancelAndArchive');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 11
        }
      }, i18n.TABLE_ACTION_CANCEL_AND_ARCHIVE),
      archive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-archive",
        key: "archive",
        icon: "folderOpen",
        onClick: () => {
          closePopover();
          showModal('archive');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 11
        }
      }, i18n.ARCHIVE),
      unarchive: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-unarchive",
        key: "unarchive",
        icon: "exit",
        onClick: () => {
          closePopover();
          showModal('unarchive');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 11
        }
      }, i18n.TABLE_ACTION_UNARCHIVE),
      delete: /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": "table-actions-delete",
        key: "delete",
        icon: "trash",
        onClick: () => {
          closePopover();
          showModal('delete');
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 11
        }
      }, i18n.TABLE_ACTION_DELETE)
    };
    const statusMenuItemsMap = {
      running: ['edit', 'copyId', 'cancel', 'cancelAndArchive', 'delete'],
      upcoming: ['edit', 'copyId', 'archive', 'delete'],
      finished: ['edit', 'copyId', 'archive', 'delete'],
      archived: ['copyId', 'unarchive', 'delete']
    };
    return statusMenuItemsMap[status].map(type => menuItems[type]);
  }, [status, closePopover, onEdit, id, toasts, showModal]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    isDisabled: isLoading,
    "data-test-subj": "table-actions-icon-button",
    iconType: "boxesHorizontal",
    size: "s",
    "aria-label": "Upcoming events",
    onClick: onButtonClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }), [isLoading, onButtonClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    "data-test-subj": "table-actions-popover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  })))), modal);
});
TableActionsPopover.displayName = 'TableActionsPopover';