"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MINIMUM_TIME_RANGE = exports.DEFAULT_MINIMUM_TIME_RANGE_OPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_MINIMUM_TIME_RANGE_OPTION = exports.DEFAULT_MINIMUM_TIME_RANGE_OPTION = 'No minimum';
const MINIMUM_TIME_RANGE = exports.MINIMUM_TIME_RANGE = {
  'No minimum': {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.minimumTimeRange.noMin', {
      defaultMessage: 'Use range specified in time selector'
    }),
    factor: 0,
    unit: 'w'
  },
  '1 week': {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.minimumTimeRange.1week', {
      defaultMessage: '1 week'
    }),
    factor: 1,
    unit: 'w'
  },
  '1 month': {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.minimumTimeRange.1month', {
      defaultMessage: '1 month'
    }),
    factor: 1,
    unit: 'M'
  },
  '3 months': {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.minimumTimeRange.3months', {
      defaultMessage: '3 months'
    }),
    factor: 3,
    unit: 'M'
  },
  '6 months': {
    label: _i18n.i18n.translate('xpack.aiops.logCategorization.minimumTimeRange.6months', {
      defaultMessage: '6 months'
    }),
    factor: 6,
    unit: 'M'
  }
};