"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeSeriesDataViewWarning = timeSeriesDataViewWarning;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/application/utils/time_series_dataview_check.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function timeSeriesDataViewWarning(dataView, feature) {
  if (dataView.isTimeBased()) {
    return null;
  }
  let description = '';
  if (feature === 'change_point_detection') {
    description = _i18n.i18n.translate('xpack.aiops.changePointTimeSeriesWarning.description', {
      defaultMessage: 'Change point detection only runs over time-based indices.'
    });
  } else if (feature === 'log_categorization') {
    description = _i18n.i18n.translate('xpack.aiops.logCategorizationTimeSeriesWarning.description', {
      defaultMessage: 'Log pattern analysis only runs over time-based indices.'
    });
  } else if (feature === 'log_rate_analysis') {
    description = _i18n.i18n.translate('xpack.aiops.logRateAnalysisTimeSeriesWarning.description', {
      defaultMessage: 'Log rate analysis only runs over time-based indices.'
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.aiops.dataViewNotBasedOnTimeSeriesWarning.title', {
      defaultMessage: 'The data view "{dataViewTitle}" is not based on a time series.',
      values: {
        dataViewTitle: dataView.getName()
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, description));
}