"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridFooterStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../../global_styling");
var _data_grid = require("../../data_grid.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridFooterStyles = exports.euiDataGridFooterStyles = function euiDataGridFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiDataGridVariables = (0, _data_grid.euiDataGridVariables)(euiThemeContext),
    levels = _euiDataGridVariables.levels;
  return {
    euiDataGridFooter: /*#__PURE__*/(0, _react.css)("display:flex;", (0, _global_styling.logicalCSS)('width', 'fit-content'), " background-color:", euiTheme.colors.emptyShade, ";;label:euiDataGridFooter;"),
    sticky: /*#__PURE__*/(0, _react.css)("z-index:", levels.stickyHeader, ";position:sticky;", (0, _global_styling.logicalCSS)('bottom', 0), ";;label:sticky;"),
    overline: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('border-top', "".concat(euiTheme.border.width.thick, " solid ").concat(euiTheme.colors.textParagraph)), ";;label:overline;"),
    shade: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.lightestShade, ";;label:shade;"),
    striped: /*#__PURE__*/(0, _react.css)(".euiDataGrid--stripes &{background-color:", euiTheme.colors.lightestShade, ";};label:striped;"),
    euiDataGridFooterCell: /*#__PURE__*/(0, _react.css)("flex:0 0 auto;font-weight:", euiTheme.font.weight.bold, ";;label:euiDataGridFooterCell;")
  };
};