"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIsInitializedSelector = exports.InitStatus = void 0;
const create_selector_1 = require("../create_selector");
exports.InitStatus = Object.freeze({
    ParentSizeInvalid: 'ParentSizeInvalid',
    SpecNotInitialized: 'SpecNotInitialized',
    MissingChartType: 'MissingChartType',
    ChartNotInitialized: 'ChartNotInitialized',
    Initialized: 'Initialized',
});
exports.getIsInitializedSelector = (0, create_selector_1.createCustomCachedSelector)([
    (state) => state.specsInitialized,
    (state) => state.parentDimensions.width,
    (state) => state.parentDimensions.height,
], (specsInitialized, width, height) => {
    if (!specsInitialized) {
        return exports.InitStatus.SpecNotInitialized;
    }
    if (width <= 0 || height <= 0) {
        return exports.InitStatus.ParentSizeInvalid;
    }
    return exports.InitStatus.MissingChartType;
});
//# sourceMappingURL=get_is_initialized.js.map