"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedAppsApiClient = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _exception_list_items = require("../../../../common/utils/exception_list_items");
var _exceptions_list_api_client = require("../../../services/exceptions_list/exceptions_list_api_client");
var _constants = require("../constants");
var _constants2 = require("../../../../../common/endpoint/constants");
var _resolve_path_variables = require("../../../../common/utils/resolve_path_variables");
var _utils = require("../../../../../common/endpoint/service/artifacts/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function readTransform(item) {
  if (!(0, _utils.isAdvancedModeEnabled)(item)) {
    return {
      ...item,
      entries: (0, _exception_list_items.entriesToConditionEntries)(item.entries)
    };
  }
  return item;
}
function writeTransform(item) {
  if (!(0, _utils.isAdvancedModeEnabled)(item)) {
    return {
      ...item,
      entries: (0, _exception_list_items.conditionEntriesToEntries)(item.entries, true)
    };
  }
  return item;
}

/**
 * Trusted Apps exceptions Api client class using ExceptionsListApiClient as base class
 * It follows the Singleton pattern.
 * Please, use the getInstance method instead of creating a new instance when using this implementation.
 */
class TrustedAppsApiClient extends _exceptions_list_api_client.ExceptionsListApiClient {
  constructor(http) {
    super(http, _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id, _constants.TRUSTED_APPS_EXCEPTION_LIST_DEFINITION, readTransform, writeTransform);
  }
  static getInstance(http) {
    return super.getInstance(http, _securitysolutionListConstants.ENDPOINT_ARTIFACT_LISTS.trustedApps.id, _constants.TRUSTED_APPS_EXCEPTION_LIST_DEFINITION, readTransform, writeTransform);
  }

  /**
   * Returns suggestions for given field
   */
  async getSuggestions(body) {
    const result = await this.getHttp().post((0, _resolve_path_variables.resolvePathVariables)(_constants2.SUGGESTIONS_INTERNAL_ROUTE, {
      suggestion_type: 'trustedApps'
    }), {
      version: '1',
      body: JSON.stringify(body)
    });
    return result;
  }
}
exports.TrustedAppsApiClient = TrustedAppsApiClient;