"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SWITCH_LABEL = exports.LOCKED_CARD_ATTACK_SURFACE_REDUCTION = exports.AttackSurfaceReductionCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _setting_locked_card = require("../setting_locked_card");
var _setting_card = require("../setting_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/attack_surface_reduction_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ATTACK_SURFACE_OS_LIST = [_securitysolutionUtils.OperatingSystem.WINDOWS];
const LOCKED_CARD_ATTACK_SURFACE_REDUCTION = exports.LOCKED_CARD_ATTACK_SURFACE_REDUCTION = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.attack_surface_reduction', {
  defaultMessage: 'Attack Surface Reduction'
});
const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.attackSurfaceReduction.type', {
  defaultMessage: 'Attack surface reduction'
});
const SWITCH_LABEL = exports.SWITCH_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.credentialHardening', {
  defaultMessage: 'Credential hardening'
});
const AttackSurfaceReductionCard = exports.AttackSurfaceReductionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const isChecked = policy.windows.attack_surface_reduction.credential_hardening.enabled;
  const isEditMode = mode === 'edit';
  const handleSwitchChange = (0, _react.useCallback)(event => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    updatedPolicy.windows.attack_surface_reduction.credential_hardening.enabled = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [onChange, policy]);
  if (!isProtectionsAllowed) {
    return null;
  }
  if (!isPlatinumPlus) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: LOCKED_CARD_ATTACK_SURFACE_REDUCTION,
      "data-test-subj": getTestId('locked'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: CARD_TITLE,
    supportedOss: ATTACK_SURFACE_OS_LIST,
    dataTestSubj: getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: SWITCH_LABEL,
    checked: isChecked,
    disabled: !isEditMode,
    onChange: handleSwitchChange,
    "data-test-subj": getTestId('enableDisableSwitch'),
    labelProps: {
      'data-test-subj': getTestId('switchLabel')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }));
});
AttackSurfaceReductionCard.displayName = 'AttackSurfaceReductionCard';