"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _policy_hooks = require("./policy_hooks");
var _selectors = require("../store/policy_details/selectors");
var _agents_summary = require("./components/agents_summary");
var _tabs = require("./tabs");
var _administration_list_page = require("../../../components/administration_list_page");
var _back_to_external_app_button = require("../../../components/back_to_external_app_button/back_to_external_app_button");
var _routing = require("../../../common/routing");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PolicyDetails = exports.PolicyDetails = /*#__PURE__*/_react.default.memo(() => {
  var _policyItem$name, _policyItem$descripti, _policyAgentStatusSum, _policyAgentStatusSum2, _policyAgentStatusSum3, _policyAgentStatusSum4;
  const {
    state: routeState = {}
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();

  // Store values
  const policyApiError = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.apiError);
  const policyItem = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const policyAgentStatusSummary = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.agentStatusSummary);

  // Local state
  const policyName = (_policyItem$name = policyItem === null || policyItem === void 0 ? void 0 : policyItem.name) !== null && _policyItem$name !== void 0 ? _policyItem$name : '';
  const policyDescription = (_policyItem$descripti = policyItem === null || policyItem === void 0 ? void 0 : policyItem.description) !== null && _policyItem$descripti !== void 0 ? _policyItem$descripti : undefined;
  const backLinkOptions = (0, _react.useMemo)(() => {
    if (routeState !== null && routeState !== void 0 && routeState.backLink) {
      return {
        onBackButtonNavigateTo: routeState.backLink.navigateTo,
        backButtonLabel: routeState.backLink.label,
        backButtonUrl: routeState.backLink.href
      };
    }
    const policyListPath = (0, _routing.getPoliciesPath)();
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.policyDetails.backToPolicyButton', {
        defaultMessage: 'Back to policy list'
      }),
      backButtonUrl: getAppUrl({
        path: policyListPath
      }),
      onBackButtonNavigateTo: [_constants.APP_UI_ID, {
        path: policyListPath
      }]
    };
  }, [getAppUrl, routeState === null || routeState === void 0 ? void 0 : routeState.backLink]);
  const headerRightContent = /*#__PURE__*/_react.default.createElement(_agents_summary.AgentsSummary, {
    total: (_policyAgentStatusSum = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.active) !== null && _policyAgentStatusSum !== void 0 ? _policyAgentStatusSum : 0,
    online: (_policyAgentStatusSum2 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.online) !== null && _policyAgentStatusSum2 !== void 0 ? _policyAgentStatusSum2 : 0,
    offline: (_policyAgentStatusSum3 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.offline) !== null && _policyAgentStatusSum3 !== void 0 ? _policyAgentStatusSum3 : 0,
    error: (_policyAgentStatusSum4 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.error) !== null && _policyAgentStatusSum4 !== void 0 ? _policyAgentStatusSum4 : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
  const backToEndpointList = /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, (0, _extends2.default)({}, backLinkOptions, {
    "data-test-subj": "policyDetailsBackLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }));
  const pageBody = (0, _react.useMemo)(() => {
    if (policyApiError) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
        grow: false,
        alignment: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        title: policyApiError === null || policyApiError === void 0 ? void 0 : policyApiError.error,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "policyDetailsIdNotFoundMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 13
        }
      }, policyApiError === null || policyApiError === void 0 ? void 0 : policyApiError.message)));
    }
    if (!policyItem) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
        grow: false,
        alignment: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        className: "essentialAnimation",
        size: "xl",
        "data-test-subj": "policyDetailsLoading",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_tabs.PolicyTabs, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 12
      }
    });
  }, [policyApiError, policyItem]);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "policyDetailsPage",
    title: policyName,
    subtitle: policyDescription,
    headerBackComponent: backToEndpointList,
    actions: policyApiError ? undefined : headerRightContent,
    restrictWidth: true,
    hasBottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, pageBody);
});
PolicyDetails.displayName = 'PolicyDetails';