"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWithShowResponder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_license = require("../../common/hooks/use_license");
var _agent_info = require("../components/endpoint_responder/components/header_info/agent_info/agent_info");
var _user_privileges = require("../../common/components/user_privileges");
var _endpoint_responder = require("../components/endpoint_responder");
var _console = require("../components/console");
var _missing_encryption_key_callout = require("../components/missing_encryption_key_callout");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/hooks/use_with_show_responder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useWithShowResponder = () => {
  const consoleManager = (0, _console.useConsoleManager)();
  const endpointPrivileges = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isEnterpriseLicense = (0, _use_license.useLicense)().isEnterprise();
  return (0, _react.useCallback)(props => {
    const {
      agentId,
      agentType,
      capabilities,
      hostName,
      platform
    } = props;

    // If no authz, just exit and log something to the console
    if (agentType === 'endpoint' && !endpointPrivileges.canAccessResponseConsole) {
      window.console.error(new Error(`Access denied to ${agentType} response actions console`));
      return;
    }
    if (agentType !== 'endpoint' && !isEnterpriseLicense) {
      window.console.error(new Error(`Access denied to ${agentType} response actions console`));
      return;
    }
    const endpointRunningConsole = consoleManager.getOne(agentId);
    if (endpointRunningConsole) {
      endpointRunningConsole.show();
    } else {
      const consoleProps = {
        commands: (0, _endpoint_responder.getEndpointConsoleCommands)({
          agentType,
          endpointAgentId: agentId,
          endpointCapabilities: capabilities,
          endpointPrivileges,
          platform: platform
        }),
        'data-test-subj': `${agentType}ResponseActionsConsole`,
        storagePrefix: 'xpack.securitySolution.Responder',
        TitleComponent: () => {
          return /*#__PURE__*/_react.default.createElement(_agent_info.AgentInfo, {
            agentId: agentId,
            agentType: agentType,
            hostName: hostName,
            platform: platform,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 83,
              columnNumber: 15
            }
          });
        }
      };
      consoleManager.register({
        id: agentId,
        meta: {
          agentId,
          hostName,
          capabilities,
          platform
        },
        consoleProps,
        PageTitleComponent: () => {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.RESPONDER_PAGE_TITLE);
        },
        ActionComponents: endpointPrivileges.canReadActionsLogManagement ? [_endpoint_responder.ActionLogButton] : undefined,
        PageBodyComponent: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_endpoint_responder.OfflineCallout, {
          endpointId: props.agentId,
          agentType: agentType,
          hostName: hostName,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 111,
            columnNumber: 17
          }
        }), /*#__PURE__*/_react.default.createElement(_missing_encryption_key_callout.MissingEncryptionKeyCallout, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 17
          }
        }))
      }).show();
    }
  }, [endpointPrivileges, isEnterpriseLicense, consoleManager]);
};
exports.useWithShowResponder = useWithShowResponder;