"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuspendProcessActionResult = void 0;
var _react = require("react");
var _utils = require("../lib/utils");
var _use_send_suspend_process_endpoint_request = require("../../../hooks/response_actions/use_send_suspend_process_endpoint_request");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuspendProcessActionResult = exports.SuspendProcessActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin3;
  const actionCreator = (0, _use_send_suspend_process_endpoint_request.useSendSuspendProcessRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$commandDefin, _command$commandDefin2, _command$args$args, _command$args$args$co;
    const {
      agentType,
      endpointId
    } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
    const parameters = (0, _utils.parsedKillOrSuspendParameter)(command.args.args);
    return endpointId ? {
      agent_type: agentType,
      endpoint_ids: [endpointId],
      comment: (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0],
      parameters
    } : undefined;
  }, [command.args.args, (_command$commandDefin3 = command.commandDefinition) === null || _command$commandDefin3 === void 0 ? void 0 : _command$commandDefin3.meta]);
  return (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    // @ts-expect-error upgrade typescript v5.4.5
    setStore,
    // @ts-expect-error upgrade typescript v5.4.5
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'suspendProcess'
  }).result;
});
SuspendProcessActionResult.displayName = 'SuspendProcessActionResult';