"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetProcessesActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _running_processes_action_results = require("../../running_processes_action_results");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_get_endpoint_processes_request = require("../../../hooks/response_actions/use_send_get_endpoint_processes_request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_responder/command_render_components/get_processes_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GetProcessesActionResult = exports.GetProcessesActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin, _command$commandDefin2, _command$args$args, _command$args$args$co;
  const {
    endpointId,
    agentType
  } = (_command$commandDefin = (_command$commandDefin2 = command.commandDefinition) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
  const comment = (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0];
  const actionCreator = (0, _use_send_get_endpoint_processes_request.useSendGetEndpointProcessesRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    return endpointId ? {
      endpoint_ids: [endpointId],
      comment,
      agent_type: agentType
    } : undefined;
  }, [endpointId, comment, agentType]);
  const {
    result,
    actionDetails: completedActionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    // @ts-expect-error upgrade typescript v5.4.5
    setStore,
    // @ts-expect-error upgrade typescript v5.4.5
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'getProcesses'
  });
  if (!completedActionDetails || !completedActionDetails.wasSuccessful) {
    return result;
  }

  // Show results
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    "data-test-subj": "getProcessesSuccessCallout",
    showTitle: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_running_processes_action_results.RunningProcessesActionResults, {
    action: completedActionDetails,
    "data-test-subj": "processesOutput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }));
});
GetProcessesActionResult.displayName = 'GetProcessesActionResult';