"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateDataReducer = exports.initiateState = void 0;
var _parsed_command_input = require("../../service/parsed_command_input");
var _handle_input_area_state = require("./state_update_handlers/handle_input_area_state");
var _handle_side_panel = require("./state_update_handlers/handle_side_panel");
var _handle_update_command_state = require("./state_update_handlers/handle_update_command_state");
var _handle_execute_command = require("./state_update_handlers/handle_execute_command");
var _builtin_commands = require("../../service/builtin_commands");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initiateState = ({
  commands: userCommandList,
  ...otherOptions
}, managedConsolePriorState) => {
  const commands = (0, _builtin_commands.getBuiltinCommands)().concat(userCommandList);
  const state = managedConsolePriorState !== null && managedConsolePriorState !== void 0 ? managedConsolePriorState : {
    commands,
    ...otherOptions,
    commandHistory: [],
    sidePanel: {
      show: null
    },
    footerContent: '',
    input: {
      leftOfCursorText: '',
      rightOfCursorText: '',
      parsedInput: (0, _parsed_command_input.parseCommandInput)(''),
      enteredCommand: undefined,
      placeholder: _handle_input_area_state.INPUT_DEFAULT_PLACEHOLDER_TEXT,
      showPopover: undefined,
      history: [],
      visibleState: undefined
    }
  };

  // If we have prior state from ConsoleManager, then ensure that its updated
  // with the initial state provided by `Console` during initial render so that
  // we don't reference stale references.
  if (managedConsolePriorState) {
    Object.assign(state, {
      commands,
      ...otherOptions
    });
  }
  return state;
};
exports.initiateState = initiateState;
const stateDataReducer = (state, action) => {
  var _state$keyCapture, _state$keyCapture$cur, _state$keyCapture2, _state$keyCapture2$cu;
  let newState = state;
  switch (action.type) {
    case 'scrollDown':
      state.scrollToBottom();
      break;
    case 'addFocusToKeyCapture':
      (_state$keyCapture = state.keyCapture) === null || _state$keyCapture === void 0 ? void 0 : (_state$keyCapture$cur = _state$keyCapture.current) === null || _state$keyCapture$cur === void 0 ? void 0 : _state$keyCapture$cur.focus();
      break;
    case 'removeFocusFromKeyCapture':
      (_state$keyCapture2 = state.keyCapture) === null || _state$keyCapture2 === void 0 ? void 0 : (_state$keyCapture2$cu = _state$keyCapture2.current) === null || _state$keyCapture2$cu === void 0 ? void 0 : _state$keyCapture2$cu.blur();
      break;
    case 'updateFooterContent':
      if (state.footerContent !== action.payload.value) {
        newState = {
          ...state,
          footerContent: action.payload.value
        };
      }
      break;
    case 'executeCommand':
      newState = (0, _handle_execute_command.handleExecuteCommand)(state, action);
      break;
    case 'updateCommandStatusState':
    case 'updateCommandStoreState':
      newState = (0, _handle_update_command_state.handleUpdateCommandState)(state, action);
      break;
    case 'showSidePanel':
      newState = (0, _handle_side_panel.handleSidePanel)(state, action);
      break;
    case 'updateInputPopoverState':
    case 'updateInputHistoryState':
    case 'clearInputHistoryState':
    case 'updateInputTextEnteredState':
    case 'updateInputPlaceholderState':
    case 'setInputState':
    case 'updateInputCommandArgState':
      newState = (0, _handle_input_area_state.handleInputAreaState)(state, action);
      break;
    case 'clear':
      newState = {
        ...state,
        commandHistory: []
      };
      break;
  }
  return newState;
};
exports.stateDataReducer = stateDataReducer;