"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeActionButton = exports.TAKE_ACTION_BUTTON_TEST_ID = exports.TAKE_ACTION_BUTTON = exports.ADD_TO_CASE_ARIA_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _objectUtils = require("@kbn/object-utils");
var _context = require("../context");
var _use_add_to_case_actions = require("../../../detections/components/alerts_table/timeline_actions/use_add_to_case_actions");
var _use_alert_tags_actions = require("../../../detections/components/alerts_table/timeline_actions/use_alert_tags_actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/take_action_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TAKE_ACTION_BUTTON_TEST_ID = exports.TAKE_ACTION_BUTTON_TEST_ID = 'alert-summary-flyout-take-action';
const TAKE_ACTION_BUTTON = exports.TAKE_ACTION_BUTTON = _i18n.i18n.translate('xpack.securitySolution.alertSummary.flyout.takeActionsAriaLabel', {
  defaultMessage: 'Take action'
});
const ADD_TO_CASE_ARIA_LABEL = exports.ADD_TO_CASE_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.alertSummary.flyout.attachToCaseAriaLabel', {
  defaultMessage: 'Attach alert to case'
});

/**
 * Take action button in the panel footer.
 * This is used in EASE alert summary page.
 * The following options are available:
 * - add to existing case
 * - add to new case
 * - apply alert tags
 */
const TakeActionButton = exports.TakeActionButton = /*#__PURE__*/(0, _react.memo)(() => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    dataAsNestedObject
  } = (0, _context.useEaseDetailsContext)();
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": TAKE_ACTION_BUTTON,
    "data-test-subj": TAKE_ACTION_BUTTON_TEST_ID,
    fill: true,
    iconSide: "right",
    iconType: "arrowDown",
    onClick: togglePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, TAKE_ACTION_BUTTON), [togglePopover]);
  const nonEcsData = (0, _react.useMemo)(() => {
    const flattened = (0, _objectUtils.flattenObject)(dataAsNestedObject);
    return Object.entries(flattened).map(([key, value]) => ({
      field: key,
      value: value
    }));
  }, [dataAsNestedObject]);
  const {
    addToCaseActionItems
  } = (0, _use_add_to_case_actions.useAddToCaseActions)({
    ecsData: dataAsNestedObject,
    nonEcsData,
    onMenuItemClick: closePopover,
    ariaLabel: ADD_TO_CASE_ARIA_LABEL
  });
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_alert_tags_actions.useAlertTagsActions)({
    closePopover,
    ecsRowData: dataAsNestedObject
  });
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    items: [...addToCaseActionItems, ...alertTagsItems]
  }, ...alertTagsPanels], [addToCaseActionItems, alertTagsItems, alertTagsPanels]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: togglePopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
});
TakeActionButton.displayName = 'TakeActionButton';