"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestedPrompts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ease/components/suggested_prompts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALERT_FROM_FLYOUT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.alertFromFlyout', {
  defaultMessage: 'Alert (from flyout)'
});
const PROMPT_1_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Title', {
  defaultMessage: 'Detailed Alert Analysis'
});
const PROMPT_1_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Description', {
  defaultMessage: 'Dive deeper into what happened with this alert.'
});
const PROMPT_1_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt1Prompt', {
  defaultMessage: "Provide a thorough breakdown of this alert, including the attack technique, potential impact, and risk assessment. Explain the technical details in a way that's immediately actionable"
});
const PROMPT_2_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Title', {
  defaultMessage: 'Best practices for noisy alerts'
});
const PROMPT_2_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Description', {
  defaultMessage: 'Find Related Threat Intelligence Articles from Elastic Security Labs.'
});
const PROMPT_2_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt2Prompt', {
  defaultMessage: 'Can you provide relevant Elastic Security Labs intelligence about the threat indicators or techniques in this alert? Include any known threat actors, campaigns, or similar attack patterns documented in ESL research.'
});
const PROMPT_3_TITLE = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Title', {
  defaultMessage: 'Alert Remediation Strategy'
});
const PROMPT_3_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Description', {
  defaultMessage: 'Generate Step-by-Step Remediation Plan.'
});
const PROMPT_3_PROMPT = _i18n.i18n.translate('xpack.securitySolution.alertSummary.prompt3Prompt', {
  defaultMessage: 'Based on this alert, please outline a comprehensive remediation plan including immediate containment steps, investigation actions, and long-term mitigation strategies to prevent similar incidents.'
});
const SUGGESTED_PROMPTS_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.alertSummary.suggestedPromptsContextTooltip', {
  defaultMessage: 'Add this alert as context.'
});
// TODO update this copy, waiting on James Spiteri's input
const prompts = [{
  icon: 'bullseye',
  prompt: PROMPT_1_PROMPT,
  title: PROMPT_1_TITLE,
  description: PROMPT_1_DESCRIPTION
}, {
  icon: 'cloudStormy',
  prompt: PROMPT_2_PROMPT,
  title: PROMPT_2_TITLE,
  description: PROMPT_2_DESCRIPTION
}, {
  icon: 'database',
  prompt: PROMPT_3_PROMPT,
  title: PROMPT_3_TITLE,
  description: PROMPT_3_DESCRIPTION
}];
const SuggestedPrompts = exports.SuggestedPrompts = /*#__PURE__*/(0, _react.memo)(({
  getPromptContext,
  ruleName,
  timestamp
}) => {
  var _promptOverlay$title, _promptOverlay$descri, _promptOverlay$prompt;
  const {
    assistantAvailability: {
      isAssistantEnabled
    }
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [promptOverlay, setPromptOverlay] = (0, _react.useState)(null);
  const onClick = (0, _react.useCallback)(prompt => {
    setPromptOverlay({
      title: `${prompt.title}: ${ruleName} - ${timestamp}`,
      description: ALERT_FROM_FLYOUT,
      prompt: prompt.prompt
    });
  }, [ruleName, timestamp]);
  const {
    showAssistantOverlay
  } = (0, _elasticAssistant.useAssistantOverlay)('alert', (_promptOverlay$title = promptOverlay === null || promptOverlay === void 0 ? void 0 : promptOverlay.title) !== null && _promptOverlay$title !== void 0 ? _promptOverlay$title : '', (_promptOverlay$descri = promptOverlay === null || promptOverlay === void 0 ? void 0 : promptOverlay.description) !== null && _promptOverlay$descri !== void 0 ? _promptOverlay$descri : '', getPromptContext, null, (_promptOverlay$prompt = promptOverlay === null || promptOverlay === void 0 ? void 0 : promptOverlay.prompt) !== null && _promptOverlay$prompt !== void 0 ? _promptOverlay$prompt : '', SUGGESTED_PROMPTS_CONTEXT_TOOLTIP, isAssistantEnabled);
  (0, _react.useEffect)(() => {
    if (promptOverlay !== null) {
      showAssistantOverlay(true);
    }
  }, [promptOverlay, showAssistantOverlay]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, prompts.map((prompt, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
            margin: ${euiTheme.size.xs} 0;
          `,
    key: index,
    paddingSize: "m",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => onClick(prompt),
    flush: "both",
    color: "text",
    iconType: prompt.icon,
    css: (0, _react2.css)`
              svg {
                inline-size: 40px;
                block-size: 40px;
                padding-inline: 10px;
                background: ${euiTheme.colors.backgroundBaseDisabled};
                border-radius: 5px;
              }
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  }, prompt.description))));
});
SuggestedPrompts.displayName = 'SuggestedPrompt';