"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutIsExpandable = void 0;
var _react = require("react");
var _utils = require("../../shared/utils");
var _get_row_renderer = require("../../../../timelines/components/timeline/body/renderers/get_row_renderer");
var _renderers = require("../../../../timelines/components/timeline/body/renderers");
var _event_utils = require("../utils/event_utils");
var _event_kinds = require("../../shared/constants/event_kinds");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook used on the right panel to decide if the flyout has an expanded section.
 * This also helps deciding if the overview section should be displayed.
 * The hook looks at the `event.kind` and `event.category` fields of the document.
 */
const useFlyoutIsExpandable = ({
  getFieldsData,
  dataAsNestedObject
}) => {
  const renderer = (0, _get_row_renderer.getRowRenderer)({
    data: dataAsNestedObject,
    rowRenderers: _renderers.defaultRowRenderers
  });
  const eventKind = (0, _utils.getField)(getFieldsData('event.kind'));
  const eventKindInECS = eventKind && (0, _event_utils.isEcsAllowedValue)('event.kind', eventKind);
  const eventCategories = (0, _utils.getFieldArray)(getFieldsData('event.category'));
  const eventCategoryInECS = eventCategories.some(category => (0, _event_utils.isEcsAllowedValue)('event.category', category));
  return (0, _react.useMemo)(() => {
    // alert document: always show overview
    if (eventKind === _event_kinds.EventKind.signal) {
      return true;
    }
    // event document: show overview when event category is ecs compliant or event renderer is available
    if (eventKind === _event_kinds.EventKind.event) {
      return eventCategoryInECS || renderer != null;
    }
    // non-event document: show overview when event kind is ecs compliant or event renderer is available
    return eventKindInECS || renderer != null;
  }, [eventKind, eventCategoryInECS, eventKindInECS, renderer]);
};
exports.useFlyoutIsExpandable = useFlyoutIsExpandable;