"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallOutBody = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../common/lib/kibana");
var _missing_privileges = require("../../../common/components/missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_engine_privileges_callout/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MISSING_PRIVILEGES_CALLOUT_TITLE = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageTitle', {
  defaultMessage: 'Insufficient privileges'
});
const MissingPrivilegesCallOutBody = ({
  indexPrivileges,
  clusterPrivileges
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.messageDetail",
    defaultMessage: "{essence} {indexPrivileges} {clusterPrivileges} ",
    values: {
      essence: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.essenceDescription",
        defaultMessage: "You need the following privileges to fully access this functionality. Contact your administrator for further assistance. Read more about {docs}.",
        values: {
          docs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: docLinks.links.securitySolution.entityAnalytics.riskScorePrerequisites,
            target: "_blank",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 41,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.riskEngineRequirementsDocLink",
            defaultMessage: "Risk Scoring prerequisites",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 45,
              columnNumber: 21
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 13
        }
      })),
      indexPrivileges: indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
        defaultMessage: "Missing Elasticsearch index privileges:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      }, indexPrivileges.map(([index, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
        key: index,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 19
        }
      }, missingIndexPrivileges(index, missingPrivileges))))) : null,
      clusterPrivileges: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, clusterPrivileges.enable.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.clusterPrivilegesEnableTitle",
        defaultMessage: "Missing Elasticsearch cluster privileges to enable Risk Score engine:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 17
        }
      }, clusterPrivileges.enable.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
        key: privilege,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 21
        }
      }, privilege)))), clusterPrivileges.run.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.clusterPrivilegesRunTitle",
        defaultMessage: "Missing Elasticsearch cluster privileges to run Risk Score engine:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 17
        }
      }, clusterPrivileges.run.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
        key: privilege,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 21
        }
      }, privilege)))))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
exports.MissingPrivilegesCallOutBody = MissingPrivilegesCallOutBody;
const missingIndexPrivileges = (index, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} index.",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_missing_privileges.CommaSeparatedValues, {
      values: privileges,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 19
      }
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 14
      }
    }, index)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 3
  }
});