"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useListsIndex = void 0;
var _react = require("react");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_lists_privileges = require("./use_lists_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines whether an error response from the `readListIndex`
 * API call indicates that the index is not yet created.
 */
const isIndexNotCreatedError = err => {
  return (0, _securitysolutionTGrid.isSecurityAppError)(err) && err.body.status_code === 404;
};
const useListsIndex = () => {
  const {
    lists
  } = (0, _kibana.useKibana)().services;
  const http = (0, _kibana.useHttp)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    canReadIndex,
    canManageIndex,
    canWriteIndex
  } = (0, _use_lists_privileges.useListsPrivileges)();
  const {
    loading: createLoading,
    start: createListIndex,
    error: createListError
  } = (0, _securitysolutionListHooks.useCreateListIndex)({
    http,
    onError: err => {
      if (err != null) {
        addError(err, {
          title: i18n.LISTS_INDEX_CREATE_FAILURE
        });
      }
    }
  });
  const {
    loading: readLoading,
    result: readResult,
    error: readError
  } = (0, _securitysolutionListHooks.useReadListIndex)({
    http,
    isEnabled: Boolean(lists && canReadIndex && canManageIndex && !createLoading),
    onError: err => {
      if (isIndexNotCreatedError(err)) {
        return;
      }
      addError(err, {
        title: i18n.LISTS_INDEX_FETCH_FAILURE
      });
    }
  });
  const loading = readLoading || createLoading;
  const createIndex = (0, _react.useCallback)(() => {
    if (lists && canManageIndex && canWriteIndex) {
      createListIndex();
    }
  }, [createListIndex, lists, canManageIndex, canWriteIndex]);
  const indexExists = (0, _react.useMemo)(() => {
    if (isIndexNotCreatedError(readError)) {
      return false;
    }
    return readResult != null ? readResult.list_index && readResult.list_item_index : null;
  }, [readError, readResult]);
  return {
    createIndex,
    error: createListError || isIndexNotCreatedError(readError) ? undefined : readError,
    indexExists,
    loading
  };
};
exports.useListsIndex = useListsIndex;